/*
 * Decompiled with CFR 0.152.
 */
package com.coloryr.allmusic.server.side.bukkit;

import com.coloryr.allmusic.server.AllMusicBukkit;
import com.coloryr.allmusic.server.core.AllMusic;
import com.coloryr.allmusic.server.core.music.play.PlayMusic;
import com.coloryr.allmusic.server.core.music.play.TopLyricSave;
import com.coloryr.allmusic.server.core.objs.music.TopSongInfoObj;
import com.coloryr.allmusic.server.lib.org.jetbrains.annotations.NotNull;
import com.google.common.collect.Iterables;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.messaging.PluginMessageListener;

public class PluginMessage
implements PluginMessageListener {
    public static int size;
    public static String allList;
    public static boolean update;
    private static ScheduledExecutorService service;
    private final TopSongInfoObj info = (TopSongInfoObj)PlayMusic.nowPlayMusic;
    private final TopLyricSave lyric = (TopLyricSave)PlayMusic.lyric;

    public PluginMessage() {
        service = Executors.newSingleThreadScheduledExecutor();
        service.scheduleAtFixedRate(PluginMessage::clear, 0L, 30L, TimeUnit.SECONDS);
    }

    private static void clear() {
        update = false;
    }

    private static void sendPack(ByteArrayDataOutput out) {
        Player player = (Player)Iterables.getFirst((Iterable)Bukkit.getOnlinePlayers(), null);
        if (player == null) {
            return;
        }
        player.sendPluginMessage(AllMusicBukkit.plugin, "allmusic:channelbc", out.toByteArray());
    }

    public static void startUpdate() {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeInt(255);
        out.writeUTF("allmusic");
        PluginMessage.sendPack(out);
    }

    public void stop() {
        service.shutdownNow();
    }

    public void onPluginMessageReceived(String channel, @NotNull Player player, byte[] message) {
        if (!channel.equals("allmusic:channelbc")) {
            return;
        }
        ByteArrayDataInput in = ByteStreams.newDataInput((byte[])message);
        int type = in.readInt();
        update = true;
        switch (type) {
            case 0: {
                this.info.setName(in.readUTF());
                break;
            }
            case 1: {
                this.info.setAl(in.readUTF());
                break;
            }
            case 2: {
                this.info.setAlia(in.readUTF());
                break;
            }
            case 3: {
                this.info.setAuthor(in.readUTF());
                break;
            }
            case 4: {
                this.info.setCall(in.readUTF());
                break;
            }
            case 5: {
                size = in.readInt();
                break;
            }
            case 6: {
                allList = in.readUTF();
                break;
            }
            case 7: {
                this.lyric.setLyric(in.readUTF());
                break;
            }
            case 8: {
                this.lyric.setTlyric(in.readUTF());
                break;
            }
            case 9: {
                this.lyric.setHaveT(in.readBoolean());
                break;
            }
            case 10: {
                this.lyric.setKly(in.readUTF());
                break;
            }
            case 11: {
                this.lyric.setHaveK(in.readBoolean());
                break;
            }
            case 12: {
                String uuid = in.readUTF();
                int cost = in.readInt();
                String name = in.readUTF();
                ByteArrayDataOutput out = ByteStreams.newDataOutput();
                out.write(12);
                out.writeUTF(uuid);
                if (AllMusic.economy == null) {
                    out.write(0);
                    PluginMessage.sendPack(out);
                    break;
                }
                if (!AllMusic.economy.check(name, cost)) {
                    out.write(1);
                    PluginMessage.sendPack(out);
                    break;
                }
                out.write(2);
                PluginMessage.sendPack(out);
                break;
            }
            case 13: {
                String uuid = in.readUTF();
                int cost = in.readInt();
                String name = in.readUTF();
                ByteArrayDataOutput out = ByteStreams.newDataOutput();
                out.write(13);
                out.writeUTF(uuid);
                if (AllMusic.economy == null) {
                    out.write(0);
                    PluginMessage.sendPack(out);
                    break;
                }
                if (!AllMusic.economy.cost(name, cost)) {
                    out.write(1);
                    PluginMessage.sendPack(out);
                    break;
                }
                out.write(2);
                PluginMessage.sendPack(out);
                break;
            }
        }
    }

    static {
        update = false;
    }
}

