/*
 * Decompiled with CFR 0.152.
 */
package com.coloryr.allmusic.server.core.utils;

import com.coloryr.allmusic.server.core.AllMusic;
import com.coloryr.allmusic.server.core.music.play.LyricSave;
import com.coloryr.allmusic.server.core.music.play.PlayMusic;
import com.coloryr.allmusic.server.core.objs.config.LimitObj;
import com.coloryr.allmusic.server.core.objs.config.SaveObj;
import com.coloryr.allmusic.server.core.objs.enums.HudDirType;
import com.coloryr.allmusic.server.core.objs.enums.HudType;
import com.coloryr.allmusic.server.core.objs.hud.PosObj;
import com.coloryr.allmusic.server.core.objs.message.ARG;
import com.coloryr.allmusic.server.core.objs.music.SongInfoObj;
import com.coloryr.allmusic.server.core.sql.DataSql;
import com.coloryr.allmusic.server.core.utils.Function;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class HudUtils {
    private static final Map<String, SaveObj> HudList = new ConcurrentHashMap<String, SaveObj>();

    public static SaveObj get(String name) {
        if (!HudList.containsKey(name = name.toLowerCase(Locale.ROOT))) {
            SaveObj obj1 = DataSql.readHud(name);
            if (obj1 == null) {
                SaveObj obj2 = AllMusic.getConfig().defaultHud.copy();
                HudList.put(name, obj2);
                String finalName = name;
                DataSql.task(() -> DataSql.addUser(finalName, obj2));
                return obj2;
            }
            HudList.put(name, obj1);
            return obj1;
        }
        return HudList.get(name);
    }

    public static void addAndSave(String name, SaveObj hud) {
        name = name.toLowerCase(Locale.ROOT);
        HudList.put(name, hud);
        String finalName = name;
        DataSql.task(() -> DataSql.addUser(finalName, hud));
    }

    public static PosObj setHudPos(String player, HudType pos, String x, String y) {
        SaveObj obj2 = HudUtils.get(player);
        if (obj2 == null) {
            obj2 = AllMusic.getConfig().defaultHud.copy();
        }
        PosObj posOBJ = new PosObj(0, 0, HudDirType.TOP_LEFT, 0xFFFFFF, false, true);
        if (!Function.isInteger(x) && !Function.isInteger(y)) {
            return null;
        }
        int x1 = Integer.parseInt(x);
        int y1 = Integer.parseInt(y);
        switch (pos) {
            case LYRIC: {
                posOBJ = obj2.lyric;
                break;
            }
            case LIST: {
                posOBJ = obj2.list;
                break;
            }
            case INFO: {
                posOBJ = obj2.info;
                break;
            }
            case PIC: {
                posOBJ = obj2.pic;
            }
        }
        posOBJ.x = x1;
        posOBJ.y = y1;
        HudUtils.addAndSave(player, obj2);
        HudUtils.sendHudPos(player);
        return posOBJ;
    }

    public static void sendHudListData() {
        String info;
        if (PlayMusic.getListSize() == 0) {
            info = AllMusic.getMessage().hud.emptyList;
        } else {
            StringBuilder list = new StringBuilder();
            for (SongInfoObj info1 : PlayMusic.getList()) {
                if (info1 == null) continue;
                String now = AllMusic.getMessage().musicPlay.musicInfo.replace(ARG.musicName, HudUtils.listLimit(info1.getName())).replace(ARG.musicAuthor, HudUtils.listLimit(info1.getAuthor())).replace(ARG.musicAl, HudUtils.listLimit(info1.getAl())).replace(ARG.musicAlia, HudUtils.listLimit(info1.getAlia())).replace(ARG.player, info1.getCall());
                list.append(now).append("\n");
            }
            info = AllMusic.getMessage().hud.list.replace(ARG.size, String.valueOf(PlayMusic.getList().size())).replace(ARG.list, list.toString());
        }
        AllMusic.side.sendHudList(info);
    }

    private static String tranTime(long time) {
        long m = time / 60L;
        long s = time - m * 60L;
        return (m < 10L ? "0" : "") + m + ":" + (s < 10L ? "0" : "") + s;
    }

    public static void sendHudNowData() {
        String info = PlayMusic.nowPlayMusic == null ? AllMusic.getMessage().hud.emptyMusic : AllMusic.getMessage().hud.music.replace(ARG.name, HudUtils.infoLimit(PlayMusic.nowPlayMusic.getName())).replace(ARG.allTime, HudUtils.tranTime(PlayMusic.musicAllTime)).replace(ARG.nowTime, HudUtils.tranTime(PlayMusic.musicNowTime / 1000L)).replace(ARG.musicAuthor, HudUtils.infoLimit(PlayMusic.nowPlayMusic.getAuthor())).replace(ARG.musicAlia, HudUtils.infoLimit(PlayMusic.nowPlayMusic.getAlia())).replace(ARG.musicAl, HudUtils.infoLimit(PlayMusic.nowPlayMusic.getAl())).replace(ARG.player, PlayMusic.nowPlayMusic.getCall());
        AllMusic.side.sendHudInfo(info);
    }

    public static void sendHudLyricData() {
        String info;
        LyricSave obj2 = PlayMusic.lyric;
        if (obj2 == null) {
            info = AllMusic.getMessage().hud.emptyLyric;
        } else {
            String lyric = obj2.getLyric();
            String tLyric = obj2.getTlyric();
            String kLyric = obj2.getKly();
            info = !AllMusic.getConfig().ktvMode ? AllMusic.getMessage().hud.lyric.replace(ARG.lyric, lyric == null ? "" : lyric).replace(ARG.tlyric, tLyric != null ? tLyric : "") : AllMusic.getMessage().hud.ktv.replace(ARG.lyric, lyric != null ? lyric : "").replace(ARG.klyric, kLyric != null ? kLyric : "").replace(ARG.tlyric, tLyric != null ? tLyric : "");
        }
        AllMusic.side.sendHudLyric(info);
    }

    public static boolean setHudEnable(String player, HudType pos, String arg) {
        SaveObj obj2 = HudUtils.get(player);
        boolean res = false;
        boolean value = false;
        boolean have = false;
        if (arg != null) {
            try {
                value = Boolean.parseBoolean(arg);
                have = true;
            }
            catch (Exception e) {
                return false;
            }
        }
        if (obj2 == null) {
            obj2 = AllMusic.getConfig().defaultHud.copy();
            if (have) {
                obj2.lyric.enable = obj2.pic.enable = value;
                obj2.list.enable = obj2.pic.enable;
                obj2.info.enable = obj2.pic.enable;
                res = obj2.pic.enable;
            } else {
                obj2.pic.enable = true;
                obj2.lyric.enable = true;
                obj2.list.enable = true;
                obj2.info.enable = true;
                res = true;
            }
        } else if (pos == null) {
            if (have) {
                obj2.lyric.enable = obj2.pic.enable = value;
                obj2.list.enable = obj2.pic.enable;
                obj2.info.enable = obj2.pic.enable;
                res = obj2.pic.enable;
            } else if (obj2.info.enable && obj2.list.enable && obj2.lyric.enable && obj2.pic.enable) {
                obj2.pic.enable = false;
                obj2.lyric.enable = false;
                obj2.list.enable = false;
                obj2.info.enable = false;
            } else {
                obj2.pic.enable = true;
                obj2.lyric.enable = true;
                obj2.list.enable = true;
                obj2.info.enable = true;
                res = true;
            }
        } else {
            switch (pos) {
                case INFO: {
                    obj2.info.enable = have ? value : !obj2.info.enable;
                    res = obj2.info.enable;
                    break;
                }
                case LIST: {
                    obj2.list.enable = have ? value : !obj2.list.enable;
                    res = obj2.list.enable;
                    break;
                }
                case LYRIC: {
                    obj2.lyric.enable = have ? value : !obj2.lyric.enable;
                    res = obj2.lyric.enable;
                    break;
                }
                case PIC: {
                    obj2.pic.enable = have ? value : !obj2.pic.enable;
                    res = obj2.pic.enable;
                }
            }
        }
        HudUtils.addAndSave(player, obj2);
        HudUtils.sendHudPos(player);
        return res;
    }

    public static void clearHud() {
        AllMusic.side.clearHud();
    }

    public static void clearHud(String player) {
        AllMusic.side.clearHud(player);
    }

    public static void sendHudPos(String player) {
        AllMusic.side.runTask(() -> {
            try {
                SaveObj obj2 = HudUtils.get(player);
                if (obj2 == null) {
                    obj2 = AllMusic.getConfig().defaultHud.copy();
                    HudUtils.addAndSave(player, obj2);
                }
                AllMusic.side.sendHudPos(player);
            }
            catch (Exception e1) {
                AllMusic.log.warning("\u00a7d[AllMusic3]\u00a7c\u6570\u636e\u53d1\u9001\u53d1\u751f\u9519\u8bef");
                e1.printStackTrace();
            }
        });
    }

    public static void reset(String player) {
        SaveObj obj2 = AllMusic.getConfig().defaultHud.copy();
        HudUtils.addAndSave(player, obj2);
        HudUtils.sendHudPos(player);
    }

    public static void reset(String player, HudType type) {
        SaveObj obj2 = AllMusic.getConfig().defaultHud.copy();
        SaveObj obj1 = HudUtils.get(player);
        switch (type) {
            case INFO: {
                obj1.info = obj2.info;
                break;
            }
            case LIST: {
                obj1.list = obj2.list;
                break;
            }
            case LYRIC: {
                obj1.lyric = obj2.lyric;
                break;
            }
            case PIC: {
                obj1.pic = obj2.pic;
                obj1.picRotateSpeed = obj2.picRotateSpeed;
            }
        }
        HudUtils.addAndSave(player, obj1);
        HudUtils.sendHudPos(player);
    }

    public static boolean setPicSize(String player, String size) {
        SaveObj obj2 = HudUtils.get(player);
        if (obj2 == null) {
            obj2 = AllMusic.getConfig().defaultHud.copy();
        }
        if (!Function.isInteger(size)) {
            return false;
        }
        obj2.pic.color = Integer.parseInt(size);
        HudUtils.addAndSave(player, obj2);
        HudUtils.sendHudPos(player);
        return true;
    }

    public static boolean setPicRotate(String player, String open) {
        SaveObj obj2 = HudUtils.get(player);
        if (obj2 == null) {
            obj2 = AllMusic.getConfig().defaultHud.copy();
        }
        obj2.pic.shadow = open != null ? Boolean.parseBoolean(open) : !obj2.pic.shadow;
        HudUtils.addAndSave(player, obj2);
        HudUtils.sendHudPos(player);
        return obj2.pic.shadow;
    }

    public static boolean setPicRotateSpeed(String player, String size) {
        SaveObj obj2 = HudUtils.get(player);
        if (obj2 == null) {
            obj2 = AllMusic.getConfig().defaultHud.copy();
        }
        if (!Function.isInteger(size)) {
            return false;
        }
        obj2.picRotateSpeed = Integer.parseInt(size);
        HudUtils.addAndSave(player, obj2);
        HudUtils.sendHudPos(player);
        return true;
    }

    public static HudDirType setDir(String player, HudType hud, String arg) {
        HudDirType type = null;
        try {
            if (Function.isInteger(arg)) {
                int index = Integer.parseInt(arg);
                type = HudDirType.values()[index];
            } else {
                type = HudDirType.valueOf(arg);
            }
        }
        catch (Exception index) {
            // empty catch block
        }
        if (type == null) {
            return null;
        }
        SaveObj obj2 = HudUtils.get(player);
        if (obj2 == null) {
            obj2 = AllMusic.getConfig().defaultHud.copy();
        }
        switch (hud) {
            case INFO: {
                obj2.info.dir = type;
                break;
            }
            case LIST: {
                obj2.list.dir = type;
                break;
            }
            case LYRIC: {
                obj2.lyric.dir = type;
                break;
            }
            case PIC: {
                obj2.pic.dir = type;
            }
        }
        HudUtils.addAndSave(player, obj2);
        HudUtils.sendHudPos(player);
        return type;
    }

    public static boolean setColor(String player, HudType type, String arg) {
        int color;
        try {
            color = arg.startsWith("0x") ? Integer.parseUnsignedInt(arg.substring(2), 16) : (arg.startsWith("#") ? Integer.parseUnsignedInt(arg.substring(1), 16) : Integer.parseUnsignedInt(arg));
        }
        catch (Exception ignored) {
            return false;
        }
        SaveObj obj2 = HudUtils.get(player);
        if (obj2 == null) {
            obj2 = AllMusic.getConfig().defaultHud.copy();
        }
        switch (type) {
            case INFO: {
                obj2.info.color = color;
                break;
            }
            case LIST: {
                obj2.list.color = color;
                break;
            }
            case LYRIC: {
                obj2.lyric.color = color;
                break;
            }
            case PIC: {
                obj2.pic.color = color;
            }
        }
        HudUtils.addAndSave(player, obj2);
        HudUtils.sendHudPos(player);
        return true;
    }

    public static boolean setShadow(String name, HudType pos, String arg) {
        SaveObj obj2 = HudUtils.get(name);
        boolean res = false;
        boolean value = false;
        boolean have = false;
        if (arg != null) {
            try {
                value = Boolean.parseBoolean(arg);
                have = true;
            }
            catch (Exception e) {
                return false;
            }
        }
        if (obj2 == null) {
            obj2 = AllMusic.getConfig().defaultHud.copy();
            if (have) {
                obj2.lyric.shadow = obj2.pic.shadow = value;
                obj2.list.shadow = obj2.pic.shadow;
                obj2.info.shadow = obj2.pic.shadow;
                res = obj2.pic.shadow;
            } else {
                obj2.pic.shadow = true;
                obj2.lyric.shadow = true;
                obj2.list.shadow = true;
                obj2.info.shadow = true;
                res = true;
            }
        } else if (pos == null) {
            if (have) {
                obj2.lyric.shadow = obj2.pic.shadow = value;
                obj2.list.shadow = obj2.pic.shadow;
                obj2.info.shadow = obj2.pic.shadow;
                res = obj2.pic.shadow;
            } else if (obj2.info.shadow && obj2.list.shadow && obj2.lyric.shadow && obj2.pic.shadow) {
                obj2.pic.shadow = false;
                obj2.lyric.shadow = false;
                obj2.list.shadow = false;
                obj2.info.shadow = false;
            } else {
                obj2.pic.shadow = true;
                obj2.lyric.shadow = true;
                obj2.list.shadow = true;
                obj2.info.shadow = true;
                res = true;
            }
        } else {
            switch (pos) {
                case INFO: {
                    obj2.info.shadow = have ? value : !obj2.info.shadow;
                    res = obj2.info.shadow;
                    break;
                }
                case LIST: {
                    obj2.list.shadow = have ? value : !obj2.list.shadow;
                    res = obj2.list.shadow;
                    break;
                }
                case LYRIC: {
                    obj2.lyric.shadow = have ? value : !obj2.lyric.shadow;
                    res = obj2.lyric.shadow;
                    break;
                }
                case PIC: {
                    obj2.pic.shadow = have ? value : !obj2.pic.shadow;
                    res = obj2.pic.shadow;
                }
            }
        }
        HudUtils.addAndSave(name, obj2);
        HudUtils.sendHudPos(name);
        return res;
    }

    public static void set(String name, SaveObj obj2) {
        HudUtils.addAndSave(name, obj2);
        HudUtils.sendHudPos(name);
    }

    public static String infoLimit(String info) {
        LimitObj limit = AllMusic.getConfig().limit;
        if (limit.infoLimit && info.length() > limit.infoLimitSize) {
            info = info.substring(0, limit.infoLimitSize - 1) + limit.limitText;
        }
        return info;
    }

    public static String listLimit(String list) {
        LimitObj limit = AllMusic.getConfig().limit;
        if (limit.listLimit && list.length() > limit.listLimitSize) {
            list = list.substring(0, limit.listLimitSize - 1) + limit.limitText;
        }
        return list;
    }

    public static String messageLimit(String message) {
        LimitObj limit = AllMusic.getConfig().limit;
        if (limit.messageLimit && message.length() > limit.messageLimitSize) {
            message = message.substring(0, limit.messageLimitSize - 1) + limit.limitText;
        }
        return message;
    }
}

