/*
 * Decompiled with CFR 0.152.
 */
package com.coloryr.allmusic.server.core.sql;

import com.coloryr.allmusic.server.core.AllMusic;
import com.coloryr.allmusic.server.core.objs.config.SaveObj;
import com.coloryr.allmusic.server.core.objs.enums.HudDirType;
import com.coloryr.allmusic.server.core.objs.hud.PosObj;
import com.coloryr.allmusic.server.core.sql.Cache;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.Semaphore;

public class DataSql {
    private static final Queue<Runnable> tasks = new LinkedBlockingDeque<Runnable>();
    private static final Semaphore semaphore = new Semaphore(0);
    private static final String table = "CREATE TABLE IF NOT EXISTS \"allmusic\" (\n  \"id\" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,\n  \"name\" TEXT(60),\n  \"info_x\" integer(6),\n  \"info_y\" integer(6),\n  \"info_color\" integer(20),\n  \"info_dir\" integer(6),\n  \"info_shadow\" integer(1),\n  \"info_enable\" integer(1),\n  \"lyric_x\" integer(6),\n  \"lyric_y\" integer(6),\n  \"lyric_color\" integer(20),\n  \"lyric_dir\" integer(6),\n  \"lyric_shadow\" integer(1),\n  \"lyric_enable\" integer(1),\n  \"list_x\" integer(6),\n  \"list_y\" integer(6),\n  \"list_color\" integer(20),\n  \"list_dir\" integer(6),\n  \"list_shadow\" integer(1),\n  \"list_enable\" integer(1),\n  \"pic_x\" integer(6),\n  \"pic_y\" integer(6),\n  \"pic_dir\" integer(6),\n  \"pic_size\" integer(6),\n  \"pic_enable\" integer(1),\n  \"pic_rotate\" integer(1),\n  \"pic_rotate_speed\" integer(6)\n);";
    private static final String table1 = "CREATE TABLE IF NOT EXISTS \"allmusic_list\" (\n  \"id\" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,\n  \"sid\" TEXT(40)\n);";
    private static final String table2 = "CREATE TABLE IF NOT EXISTS \"allmusic_mute\" (\n  \"id\" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,\n  \"sid\" TEXT(60)\n);";
    private static final String table3 = "CREATE TABLE IF NOT EXISTS \"allmusic_mutelist\" (\n  \"id\" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,\n  \"sid\" TEXT(60)\n);";
    private static final String table4 = "CREATE TABLE IF NOT EXISTS \"allmusic_banlist\" (\n  \"id\" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,\n  \"sid\" TEXT(40)\n);";
    private static final String table5 = "CREATE TABLE IF NOT EXISTS \"allmusic_banplayer\" (\n  \"id\" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,\n  \"sid\" TEXT(60)\n);";
    public static File sqlFile;
    private static boolean isRun;
    private static Connection connection;

    public static void init() {
        try {
            AllMusic.log.info("\u6b63\u5728\u521d\u59cb\u5316\u6570\u636e\u5e93");
            if (connection != null) {
                connection.close();
            }
            Class.forName("org.sqlite.JDBC");
            connection = DriverManager.getConnection("jdbc:sqlite:" + sqlFile.getPath());
            Statement stat = connection.createStatement();
            stat.execute(table);
            stat.execute(table1);
            stat.execute(table2);
            stat.execute(table3);
            stat.execute(table4);
            stat.execute(table5);
            stat.close();
            Cache.updateData();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean check(String name) {
        try {
            Statement stat;
            ResultSet set;
            name = name.toLowerCase(Locale.ROOT);
            boolean have = false;
            if (connection.isReadOnly() || connection.isClosed()) {
                DataSql.init();
            }
            if ((set = (stat = connection.createStatement()).executeQuery("SELECT id FROM allmusic WHERE name ='" + name + "'")).next()) {
                have = true;
            }
            set.close();
            stat.close();
            return have;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static void update(String name, SaveObj hud) {
        name = name.toLowerCase(Locale.ROOT);
        String sql = "";
        try {
            if (connection.isReadOnly() || connection.isClosed()) {
                DataSql.init();
            }
            Statement stat = connection.createStatement();
            sql = "UPDATE allmusic SET info_x=" + hud.info.x + ",info_y=" + hud.info.y + ",info_color=" + hud.info.color + ",info_dir=" + hud.info.dir.ordinal() + ",info_shadow=" + (hud.info.shadow ? 1 : 0) + ",info_enable=" + (hud.info.enable ? 1 : 0) + ",lyric_x=" + hud.lyric.x + ",lyric_y=" + hud.lyric.y + ",lyric_color=" + hud.lyric.color + ",lyric_dir=" + hud.lyric.dir.ordinal() + ",lyric_shadow=" + (hud.lyric.shadow ? 1 : 0) + ",lyric_enable=" + (hud.lyric.enable ? 1 : 0) + ",list_x=" + hud.list.x + ",list_y=" + hud.list.y + ",list_color=" + hud.list.color + ",list_dir=" + hud.list.dir.ordinal() + ",list_shadow=" + (hud.list.shadow ? 1 : 0) + ",list_enable=" + (hud.list.enable ? 1 : 0) + ",pic_x=" + hud.pic.x + ",pic_y=" + hud.pic.y + ",pic_dir=" + hud.pic.dir.ordinal() + ",pic_enable=" + (hud.pic.enable ? 1 : 0) + ",pic_size=" + hud.pic.color + ",pic_rotate=" + (hud.pic.shadow ? 1 : 0) + ",pic_rotate_speed=" + hud.picRotateSpeed + " WHERE name='" + name + "'";
            stat.execute(sql);
            stat.close();
        }
        catch (Exception e) {
            AllMusic.log.info(sql);
            e.printStackTrace();
        }
    }

    public static void addUser(String name, SaveObj hud) {
        name = name.toLowerCase(Locale.ROOT);
        String sql = "";
        try {
            if (connection.isReadOnly() || connection.isClosed()) {
                DataSql.init();
            }
            if (DataSql.check(name)) {
                DataSql.update(name, hud);
            } else {
                Statement stat = connection.createStatement();
                sql = "INSERT INTO allmusic (name,info_x,info_y,info_enable,lyric_x,lyric_y,lyric_enable,list_x,list_y,list_enable,pic_x,pic_y,pic_enable,pic_size,pic_rotate,pic_rotate_speed,info_color,info_dir,info_shadow,lyric_color,lyric_dir,lyric_shadow,list_color,list_dir,list_shadow,pic_dir)VALUES ('" + name + "'," + hud.info.x + "," + hud.info.y + "," + (hud.info.enable ? 1 : 0) + "," + hud.lyric.x + "," + hud.lyric.y + "," + (hud.lyric.enable ? 1 : 0) + "," + hud.list.x + "," + hud.list.y + "," + (hud.list.enable ? 1 : 0) + "," + hud.pic.x + "," + hud.pic.y + "," + (hud.pic.enable ? 1 : 0) + "," + hud.pic.color + "," + (hud.pic.shadow ? 1 : 0) + "," + hud.picRotateSpeed + "," + hud.info.color + "," + hud.info.dir.ordinal() + "," + (hud.info.shadow ? 1 : 0) + "," + hud.lyric.color + "," + hud.lyric.dir.ordinal() + "," + (hud.lyric.shadow ? 1 : 0) + "," + hud.list.color + "," + hud.list.dir.ordinal() + "," + (hud.list.shadow ? 1 : 0) + "," + hud.pic.dir.ordinal() + ")";
                stat.execute(sql);
                stat.close();
            }
        }
        catch (Exception e) {
            AllMusic.log.info(sql);
            e.printStackTrace();
        }
    }

    public static SaveObj readHud(String name) {
        try {
            AllMusic.log.info("\u6b63\u5728\u8bfb\u53d6\u73a9\u5bb6\u6570\u636e:" + name);
            if (connection.isReadOnly() || connection.isClosed()) {
                DataSql.init();
            }
            Statement stat = connection.createStatement();
            ResultSet set = stat.executeQuery("SELECT info_x,info_y,info_enable,lyric_x,lyric_y,lyric_enable,list_x,list_y,list_enable,pic_x,pic_y,pic_enable,pic_size,pic_rotate,pic_rotate_speed,info_color,info_dir,info_shadow,lyric_color,lyric_dir,lyric_shadow,list_color,list_dir,list_shadow,pic_dir FROM allmusic WHERE name='" + name + "'");
            HudDirType[] vas = HudDirType.values();
            SaveObj obj2 = null;
            if (set.next()) {
                obj2 = new SaveObj();
                PosObj pos1 = new PosObj();
                pos1.x = set.getInt(1);
                pos1.y = set.getInt(2);
                (obj2.info = pos1).enable = set.getInt(3) == 1;
                PosObj pos2 = new PosObj();
                pos2.x = set.getInt(4);
                pos2.y = set.getInt(5);
                (obj2.lyric = pos2).enable = set.getInt(6) == 1;
                PosObj pos3 = new PosObj();
                pos3.x = set.getInt(7);
                pos3.y = set.getInt(8);
                (obj2.list = pos3).enable = set.getInt(9) == 1;
                PosObj pos4 = new PosObj();
                pos4.x = set.getInt(10);
                pos4.y = set.getInt(11);
                (obj2.pic = pos4).enable = set.getInt(12) == 1;
                obj2.pic.color = set.getInt(13);
                obj2.pic.shadow = set.getInt(14) == 1;
                obj2.picRotateSpeed = set.getInt(15);
                obj2.info.color = set.getInt(16);
                obj2.info.dir = vas[set.getInt(17)];
                obj2.info.shadow = set.getInt(18) == 1;
                obj2.lyric.color = set.getInt(19);
                obj2.lyric.dir = vas[set.getInt(20)];
                obj2.lyric.shadow = set.getInt(21) == 1;
                obj2.list.color = set.getInt(22);
                obj2.list.dir = vas[set.getInt(23)];
                obj2.list.shadow = set.getInt(24) == 1;
                obj2.pic.dir = vas[set.getInt(25)];
            }
            stat.close();
            return obj2;
        }
        catch (Exception e) {
            AllMusic.log.warning("\u6570\u636e\u5e93\u8bfb\u53d6\u9519\u8bef\uff0c\u8bf7\u5220\u9664\u5173\u95ed\u670d\u52a1\u5668\u5220\u9664\u6570\u636e\u5e93\uff0c\u5728\u542f\u52a8\u670d\u52a1\u5668");
            e.printStackTrace();
            return null;
        }
    }

    public static String readListItem() {
        try {
            if (connection.isReadOnly() || connection.isClosed()) {
                DataSql.init();
            }
            Statement stat = connection.createStatement();
            ResultSet set = stat.executeQuery("SELECT sid FROM allmusic_list ORDER BY random() limit 1");
            String name = null;
            if (set.next()) {
                name = set.getString(1);
            }
            stat.close();
            return name;
        }
        catch (Exception e) {
            AllMusic.log.warning("\u6570\u636e\u5e93\u8bfb\u53d6\u9519\u8bef\uff0c\u8bf7\u5220\u9664\u5173\u95ed\u670d\u52a1\u5668\u5220\u9664\u6570\u636e\u5e93\uff0c\u5728\u542f\u52a8\u670d\u52a1\u5668");
            e.printStackTrace();
            return null;
        }
    }

    public static String readListItem(int index) {
        try {
            if (connection.isReadOnly() || connection.isClosed()) {
                DataSql.init();
            }
            Statement stat = connection.createStatement();
            ResultSet set = stat.executeQuery("SELECT sid FROM allmusic_list limit 1 offset " + index);
            String name = null;
            if (set.next()) {
                name = set.getString(1);
            }
            stat.close();
            return name;
        }
        catch (Exception e) {
            AllMusic.log.warning("\u6570\u636e\u5e93\u8bfb\u53d6\u9519\u8bef\uff0c\u8bf7\u5220\u9664\u5173\u95ed\u670d\u52a1\u5668\u5220\u9664\u6570\u636e\u5e93\uff0c\u5728\u542f\u52a8\u670d\u52a1\u5668");
            e.printStackTrace();
            return null;
        }
    }

    public static int getListSize() {
        try {
            if (connection.isReadOnly() || connection.isClosed()) {
                DataSql.init();
            }
            Statement stat = connection.createStatement();
            ResultSet set = stat.executeQuery("SELECT count(sid) FROM allmusic_list");
            int count = 0;
            if (set.next()) {
                count = set.getInt(1);
            }
            stat.close();
            return count;
        }
        catch (Exception e) {
            AllMusic.log.warning("\u6570\u636e\u5e93\u8bfb\u53d6\u9519\u8bef\uff0c\u8bf7\u5220\u9664\u5173\u95ed\u670d\u52a1\u5668\u5220\u9664\u6570\u636e\u5e93\uff0c\u5728\u542f\u52a8\u670d\u52a1\u5668");
            e.printStackTrace();
            return 0;
        }
    }

    public static void addIdleList(List<String> list) {
        DataSql.task(() -> {
            try {
                AllMusic.log.info("\u6dfb\u52a0" + list.size() + "\u9996\u6b4c\u5230\u7a7a\u95f2\u6b4c\u5355");
                if (connection.isReadOnly() || connection.isClosed()) {
                    DataSql.init();
                }
                PreparedStatement pstmt = connection.prepareStatement("INSERT INTO allmusic_list (sid) VALUES (?)");
                for (String str : list) {
                    pstmt.setString(1, str);
                    pstmt.addBatch();
                }
                pstmt.executeBatch();
                pstmt.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public static void clearIdleList() {
        DataSql.task(() -> {
            try {
                if (connection.isReadOnly() || connection.isClosed()) {
                    DataSql.init();
                }
                Statement stat = connection.createStatement();
                stat.execute("DELETE FROM allmusic_list");
                stat.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public static void addBanMusic(String music) {
        DataSql.task(() -> {
            try {
                if (connection.isReadOnly() || connection.isClosed()) {
                    DataSql.init();
                }
                PreparedStatement pstmt = connection.prepareStatement("INSERT INTO allmusic_banlist (sid) VALUES (?)");
                pstmt.setString(1, music);
                pstmt.execute();
                pstmt.close();
                Cache.banMusic.add(music);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public static void removeBanMusic(String music) {
        DataSql.task(() -> {
            try {
                if (connection.isReadOnly() || connection.isClosed()) {
                    DataSql.init();
                }
                PreparedStatement pstmt = connection.prepareStatement("DELETE FROM allmusic_banlist WHERE sid=?");
                pstmt.setString(1, music);
                pstmt.execute();
                pstmt.close();
                Cache.banMusic.remove(music);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public static boolean checkBanMusic(String name) {
        return Cache.banMusic.contains(name);
    }

    public static List<String> getBanMusicList() {
        try {
            ArrayList<String> banList = new ArrayList<String>();
            if (connection.isReadOnly() || connection.isClosed()) {
                DataSql.init();
            }
            Statement stat = connection.createStatement();
            ResultSet set = stat.executeQuery("SELECT sid FROM allmusic_banlist");
            while (set.next()) {
                String musicName = set.getString("sid");
                if (musicName == null) continue;
                banList.add(musicName);
            }
            set.close();
            stat.close();
            return banList;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<String>();
        }
    }

    public static void clearBan() {
        DataSql.task(() -> {
            try {
                if (connection.isReadOnly() || connection.isClosed()) {
                    DataSql.init();
                }
                Statement stat = connection.createStatement();
                stat.execute("DELETE FROM allmusic_banlist");
                stat.close();
                Cache.banMusic.clear();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public static void addBanPlayer(String player) {
        DataSql.task(() -> {
            try {
                String player1 = player.toLowerCase(Locale.ROOT);
                if (connection.isReadOnly() || connection.isClosed()) {
                    DataSql.init();
                }
                PreparedStatement pstmt = connection.prepareStatement("INSERT INTO allmusic_banplayer (sid) VALUES (?)");
                pstmt.setString(1, player1);
                pstmt.execute();
                pstmt.close();
                Cache.banPlayers.add(player);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public static void removeBanPlayer(String player) {
        DataSql.task(() -> {
            try {
                String player1 = player.toLowerCase(Locale.ROOT);
                if (connection.isReadOnly() || connection.isClosed()) {
                    DataSql.init();
                }
                PreparedStatement pstmt = connection.prepareStatement("DELETE FROM allmusic_banplayer WHERE sid=?");
                pstmt.setString(1, player1);
                pstmt.execute();
                pstmt.close();
                Cache.banPlayers.remove(player);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public static boolean checkBanPlayer(String name) {
        return Cache.banPlayers.contains(name);
    }

    public static List<String> getBanPlayerList() {
        try {
            ArrayList<String> banList = new ArrayList<String>();
            if (connection.isReadOnly() || connection.isClosed()) {
                DataSql.init();
            }
            Statement stat = connection.createStatement();
            ResultSet set = stat.executeQuery("SELECT sid FROM allmusic_banplayer");
            while (set.next()) {
                String playerName = set.getString("sid");
                if (playerName == null) continue;
                banList.add(playerName);
            }
            set.close();
            stat.close();
            return banList;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<String>();
        }
    }

    public static void clearBanPlayer() {
        DataSql.task(() -> {
            try {
                if (connection.isReadOnly() || connection.isClosed()) {
                    DataSql.init();
                }
                Statement stat = connection.createStatement();
                stat.execute("DELETE FROM allmusic_banlist");
                stat.close();
                Cache.banPlayers.clear();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public static void addMutePlayer(String player) {
        DataSql.task(() -> {
            try {
                String player1 = player.toLowerCase(Locale.ROOT);
                if (connection.isReadOnly() || connection.isClosed()) {
                    DataSql.init();
                }
                PreparedStatement pstmt = connection.prepareStatement("INSERT INTO allmusic_mute (sid) VALUES (?)");
                pstmt.setString(1, player1);
                pstmt.execute();
                pstmt.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public static void removeMutePlayer(String player) {
        DataSql.task(() -> {
            try {
                String player1 = player.toLowerCase(Locale.ROOT);
                if (connection.isReadOnly() || connection.isClosed()) {
                    DataSql.init();
                }
                PreparedStatement pstmt = connection.prepareStatement("DELETE FROM allmusic_mute WHERE sid=?");
                pstmt.setString(1, player1);
                pstmt.execute();
                pstmt.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public static boolean checkMutePlayer(String name) {
        try {
            Statement stat;
            ResultSet set;
            name = name.toLowerCase(Locale.ROOT);
            boolean have = false;
            if (connection.isReadOnly() || connection.isClosed()) {
                DataSql.init();
            }
            if ((set = (stat = connection.createStatement()).executeQuery("SELECT id FROM allmusic_mute WHERE sid ='" + name + "'")).next()) {
                have = true;
            }
            set.close();
            stat.close();
            return have;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void addMuteListPlayer(String player) {
        DataSql.task(() -> {
            try {
                String player1 = player.toLowerCase(Locale.ROOT);
                if (connection.isReadOnly() || connection.isClosed()) {
                    DataSql.init();
                }
                PreparedStatement pstmt = connection.prepareStatement("INSERT INTO allmusic_mutelist (sid) VALUES (?)");
                pstmt.setString(1, player1);
                pstmt.execute();
                pstmt.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public static void removeMuteListPlayer(String player) {
        DataSql.task(() -> {
            try {
                String player1 = player.toLowerCase(Locale.ROOT);
                if (connection.isReadOnly() || connection.isClosed()) {
                    DataSql.init();
                }
                PreparedStatement pstmt = connection.prepareStatement("DELETE FROM allmusic_mutelist WHERE sid=?");
                pstmt.setString(1, player1);
                pstmt.execute();
                pstmt.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public static boolean checkMuteListPlayer(String name) {
        try {
            Statement stat;
            ResultSet set;
            name = name.toLowerCase(Locale.ROOT);
            boolean have = false;
            if (connection.isReadOnly() || connection.isClosed()) {
                DataSql.init();
            }
            if ((set = (stat = connection.createStatement()).executeQuery("SELECT id FROM allmusic_mutelist WHERE sid ='" + name + "'")).next()) {
                have = true;
            }
            set.close();
            stat.close();
            return have;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void task(Runnable runnable2) {
        tasks.add(runnable2);
        semaphore.release();
    }

    public static void start() {
        DataSql.init();
        Thread thread2 = new Thread(DataSql::run);
        isRun = true;
        thread2.start();
    }

    public static void stop() {
        isRun = false;
        semaphore.release();
    }

    private static void run() {
        while (isRun) {
            try {
                Runnable runnable2;
                semaphore.acquire();
                if (!isRun) {
                    return;
                }
                do {
                    if ((runnable2 = tasks.poll()) == null) continue;
                    runnable2.run();
                } while (runnable2 != null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

