/*
 * Decompiled with CFR 0.152.
 */
package com.coloryr.allmusic.server.core.side;

import com.coloryr.allmusic.server.core.AllMusic;
import com.coloryr.allmusic.server.core.objs.config.SaveObj;
import com.coloryr.allmusic.server.core.objs.enums.ComType;
import com.coloryr.allmusic.server.core.objs.enums.HudType;
import com.coloryr.allmusic.server.core.objs.music.MusicObj;
import com.coloryr.allmusic.server.core.objs.music.SongInfoObj;
import com.coloryr.allmusic.server.core.utils.HudUtils;
import java.io.File;
import java.util.Collection;
import java.util.Locale;

public abstract class BaseSide {
    public abstract void runTask(Runnable var1);

    public abstract void runTask(Runnable var1, int var2);

    public abstract boolean checkPermission(Object var1);

    public abstract boolean isPlayer(Object var1);

    public abstract boolean checkPermission(Object var1, String var2);

    public abstract boolean needPlay(boolean var1);

    public abstract Collection<?> getPlayers();

    public abstract String getPlayerName(Object var1);

    public abstract String getPlayerServer(Object var1);

    public abstract void send(Object var1, ComType var2, String var3, int var4);

    public abstract Object getPlayer(String var1);

    public abstract void sendBar(Object var1, String var2);

    public abstract File getFolder();

    public abstract void sendMessage(Object var1, String var2);

    public abstract void sendMessageRun(Object var1, String var2, String var3, String var4);

    public abstract void sendMessageSuggest(Object var1, String var2, String var3, String var4);

    public abstract boolean onMusicPlay(SongInfoObj var1);

    public abstract boolean onMusicAdd(Object var1, MusicObj var2);

    public abstract void broadcast(String var1);

    public abstract void broadcastWithRun(String var1, String var2, String var3);

    public final void reload() {
        new AllMusic().init(this.getFolder());
    }

    public final void sendPos(String player, int pos) {
        Object player1 = this.getPlayer(player);
        if (player1 == null) {
            return;
        }
        if (AllMusic.isSkip(player, this.getPlayerServer(player), true)) {
            return;
        }
        try {
            this.send(player1, ComType.POS, null, pos);
        }
        catch (Exception e) {
            AllMusic.log.warning("\u00a7d[AllMusic]\u00a7c\u6e05\u7a7aHud\u53d1\u751f\u51fa\u9519");
            e.printStackTrace();
        }
    }

    public final void sendStop(String name) {
        AllMusic.removeNowPlayPlayer(name);
        Object player = this.getPlayer(name);
        if (player == null) {
            return;
        }
        try {
            this.send(player, ComType.STOP, null, 0);
        }
        catch (Exception e) {
            AllMusic.log.warning("\u00a7d[AllMusic]\u00a7c\u505c\u6b62\u6307\u4ee4\u53d1\u9001\u51fa\u9519");
            e.printStackTrace();
        }
    }

    public final void sendStop() {
        AllMusic.clearNowPlayer();
        try {
            for (Object player : this.getPlayers()) {
                this.send(player, ComType.STOP, null, 0);
            }
        }
        catch (Exception e) {
            AllMusic.log.warning("\u00a7d[AllMusic]\u00a7c\u505c\u6b62\u6307\u4ee4\u53d1\u9001\u51fa\u9519");
            e.printStackTrace();
        }
    }

    public final void sendMusic(String player, String url) {
        AllMusic.addNowPlayPlayer(player);
        Object player1 = this.getPlayer(player);
        if (player1 == null) {
            return;
        }
        try {
            if (AllMusic.isSkip(player, this.getPlayerServer(player), false)) {
                return;
            }
            this.send(player1, ComType.PLAY, url, 0);
        }
        catch (Exception e) {
            AllMusic.log.warning("\u00a7d[AllMusic]\u00a7c\u6b4c\u66f2\u6307\u4ee4\u53d1\u9001\u51fa\u9519");
            e.printStackTrace();
        }
    }

    public final void sendHudLyric(String data) {
        for (Object player : this.getPlayers()) {
            String name = this.getPlayerName(player);
            if (name == null || AllMusic.isSkip(name = name.toLowerCase(Locale.ROOT), this.getPlayerServer(player), true)) continue;
            try {
                SaveObj obj2 = HudUtils.get(name);
                if (!obj2.lyric.enable) continue;
                this.send(player, ComType.LYRIC, data, 0);
            }
            catch (Exception e) {
                AllMusic.log.warning("\u00a7d[AllMusic]\u00a7c\u6b4c\u8bcd\u53d1\u9001\u51fa\u9519");
                e.printStackTrace();
            }
        }
    }

    public final void sendHudInfo(String data) {
        for (Object player : this.getPlayers()) {
            String name = this.getPlayerName(player);
            if (name == null || AllMusic.isSkip(name = name.toLowerCase(Locale.ROOT), this.getPlayerServer(player), true)) continue;
            try {
                SaveObj obj2 = HudUtils.get(name);
                if (!obj2.lyric.enable) continue;
                this.send(player, ComType.INFO, data, 0);
            }
            catch (Exception e) {
                AllMusic.log.warning("\u00a7d[AllMusic]\u00a7c\u6b4c\u8bcd\u4fe1\u606f\u53d1\u9001\u51fa\u9519");
                e.printStackTrace();
            }
        }
    }

    public final void sendHudPos(String name) {
        Object player = this.getPlayer(name);
        if (player == null) {
            return;
        }
        if (AllMusic.isSkip(name, null, false)) {
            return;
        }
        try {
            SaveObj obj2 = HudUtils.get(name);
            String data = AllMusic.gson.toJson(obj2);
            this.send(player, ComType.HUD, data, 0);
        }
        catch (Exception e) {
            AllMusic.log.warning("\u00a7d[AllMusic]\u00a7c\u754c\u9762\u4f4d\u7f6e\u53d1\u9001\u51fa\u9519");
            e.printStackTrace();
        }
    }

    public final void sendHud(String name, HudType pos, String data) {
        try {
            if (pos == HudType.PIC) {
                return;
            }
            Object player = this.getPlayer(name);
            if (player == null) {
                return;
            }
            if (AllMusic.isSkip(name, this.getPlayerServer(player), true)) {
                return;
            }
            switch (pos) {
                case INFO: {
                    this.send(player, ComType.INFO, data, 0);
                    break;
                }
                case LIST: {
                    this.send(player, ComType.LIST, data, 0);
                    break;
                }
                case LYRIC: {
                    this.send(player, ComType.LYRIC, data, 0);
                }
            }
        }
        catch (Exception e) {
            AllMusic.log.warning("\u00a7d[AllMusic]\u00a7c\u505c\u6b62\u6307\u4ee4\u53d1\u9001\u51fa\u9519");
            e.printStackTrace();
        }
    }

    public final void sendHudList(String data) {
        for (Object player : this.getPlayers()) {
            String name = this.getPlayerName(player);
            if (name == null || AllMusic.isSkip(name = name.toLowerCase(Locale.ROOT), this.getPlayerServer(player), true)) continue;
            try {
                SaveObj obj2 = HudUtils.get(name);
                if (!obj2.list.enable) continue;
                this.send(player, ComType.LIST, data, 0);
            }
            catch (Exception e) {
                AllMusic.log.warning("\u00a7d[AllMusic]\u00a7c\u6b4c\u66f2\u5217\u8868\u53d1\u9001\u51fa\u9519");
                e.printStackTrace();
            }
        }
    }

    public final void sendHudUtilsAll() {
        for (Object player : this.getPlayers()) {
            String name = this.getPlayerName(player);
            if (name == null) continue;
            name = name.toLowerCase(Locale.ROOT);
            try {
                SaveObj obj2 = HudUtils.get(name);
                String data = AllMusic.gson.toJson(obj2);
                this.send(player, ComType.HUD, data, 0);
            }
            catch (Exception e1) {
                AllMusic.log.warning("\u00a7d[AllMusic]\u00a7c\u6570\u636e\u53d1\u9001\u53d1\u751f\u9519\u8bef");
                e1.printStackTrace();
            }
        }
    }

    public final void sendBar(String data) {
        for (Object player : this.getPlayers()) {
            String name = this.getPlayerName(player);
            if (name == null) continue;
            name = name.toLowerCase(Locale.ROOT);
            try {
                if (AllMusic.isSkip(name, this.getPlayerServer(player), true)) continue;
                this.sendBar(player, data);
            }
            catch (Exception e1) {
                AllMusic.log.warning("\u00a7d[AllMusic]\u00a7c\u6570\u636e\u53d1\u9001\u53d1\u751f\u9519\u8bef");
                e1.printStackTrace();
            }
        }
    }

    public final void sendMusic(String url) {
        for (Object player : this.getPlayers()) {
            String name = this.getPlayerName(player);
            if (name == null || AllMusic.isSkip(name = name.toLowerCase(Locale.ROOT), this.getPlayerServer(player), false)) continue;
            try {
                this.send(player, ComType.PLAY, url, 0);
                AllMusic.addNowPlayPlayer(name);
            }
            catch (Exception e) {
                AllMusic.log.warning("\u00a7d[AllMusic]\u00a7c\u6b4c\u66f2\u6307\u4ee4\u53d1\u9001\u51fa\u9519");
                e.printStackTrace();
            }
        }
    }

    public final void sendPic(String url) {
        for (Object player : this.getPlayers()) {
            String name = this.getPlayerName(player);
            if (name == null || AllMusic.isSkip(name = name.toLowerCase(Locale.ROOT), this.getPlayerServer(player), true)) continue;
            SaveObj obj2 = HudUtils.get(name);
            if (!obj2.pic.enable) continue;
            try {
                this.send(player, ComType.IMG, url, 0);
            }
            catch (Exception e) {
                AllMusic.log.warning("\u00a7d[AllMusic]\u00a7c\u56fe\u7247\u6307\u4ee4\u53d1\u9001\u51fa\u9519");
                e.printStackTrace();
            }
        }
    }

    public final void sendPic(String player, String url) {
        Object player1 = this.getPlayer(player);
        if (player1 == null) {
            return;
        }
        if (AllMusic.isSkip(player, this.getPlayerServer(player), true)) {
            return;
        }
        try {
            this.send(player1, ComType.IMG, url, 0);
        }
        catch (Exception e) {
            AllMusic.log.warning("\u00a7d[AllMusic]\u00a7c\u56fe\u7247\u6307\u4ee4\u53d1\u9001\u51fa\u9519");
            e.printStackTrace();
        }
    }

    public final void clearHud(String name) {
        Object player = this.getPlayer(name);
        if (player == null) {
            return;
        }
        try {
            this.send(player, ComType.CLEAR, null, 0);
        }
        catch (Exception e) {
            AllMusic.log.warning("\u00a7d[AllMusic]\u00a7c\u6e05\u7a7aHud\u53d1\u751f\u51fa\u9519");
            e.printStackTrace();
        }
    }

    public final void clearHud() {
        for (Object player : this.getPlayers()) {
            try {
                this.send(player, ComType.CLEAR, null, 0);
            }
            catch (Exception e) {
                AllMusic.log.warning("\u00a7d[AllMusic]\u00a7c\u6e05\u7a7aHud\u53d1\u751f\u51fa\u9519");
                e.printStackTrace();
            }
        }
    }

    public final void broadcastInTask(String data) {
        this.runTask(() -> this.broadcast(data));
    }

    public final void sendMessageTask(Object obj2, String message) {
        this.runTask(() -> this.sendMessage(obj2, message));
    }

    public void updateInfo() {
    }

    public void updateLyric() {
    }

    public void ping() {
    }
}

