/*
 * Decompiled with CFR 0.152.
 */
package com.coloryr.allmusic.server.core.music.play;

import com.coloryr.allmusic.server.core.AllMusic;
import com.coloryr.allmusic.server.core.music.play.LyricSave;
import com.coloryr.allmusic.server.core.music.play.PlayMusic;
import com.coloryr.allmusic.server.core.objs.message.ARG;
import com.coloryr.allmusic.server.core.objs.music.SongInfoObj;
import com.coloryr.allmusic.server.core.utils.HudUtils;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class PlayRuntime {
    private static int count = 0;
    private static int ping = 0;
    private static boolean isRun;
    private static int times;
    private static ScheduledExecutorService service;
    private static ScheduledExecutorService service1;
    private static ScheduledExecutorService service2;

    public static void start() {
        Thread taskT = new Thread(PlayRuntime::task, "AllMusicPlay");
        isRun = true;
        taskT.start();
        service2 = Executors.newSingleThreadScheduledExecutor();
        service2.scheduleAtFixedRate(PlayRuntime::time3, 0L, 1L, TimeUnit.SECONDS);
    }

    public static void stop() {
        PlayRuntime.closeTimer();
        if (service2 != null) {
            service2.shutdown();
            service2 = null;
        }
        isRun = false;
        PlayMusic.musicLessTime = 0L;
    }

    private static void closeTimer() {
        if (service != null) {
            service.shutdown();
            service = null;
        }
        if (service1 != null) {
            service1.shutdown();
            service1 = null;
        }
    }

    private static void startTimer() {
        service = Executors.newSingleThreadScheduledExecutor();
        service.scheduleAtFixedRate(PlayRuntime::time1, 0L, 10L, TimeUnit.MILLISECONDS);
        if (PlayMusic.lyric != null && PlayMusic.lyric.isHaveLyric()) {
            service1 = Executors.newSingleThreadScheduledExecutor();
            service1.scheduleAtFixedRate(PlayRuntime::time2, 0L, 2L, TimeUnit.MILLISECONDS);
        }
    }

    private static void clear() {
        PlayRuntime.closeTimer();
        PlayMusic.musicNowTime = 0L;
        PlayMusic.musicAllTime = 0L;
        PlayMusic.musicLessTime = 0L;
        PlayMusic.lyric = null;
        PlayMusic.nowPlayMusic = null;
        AllMusic.side.updateInfo();
        HudUtils.clearHud();
        HudUtils.sendHudNowData();
        HudUtils.sendHudLyricData();
        HudUtils.sendHudListData();
    }

    private static void time1() {
        PlayMusic.musicNowTime += 10L;
        if (++count == 100) {
            --PlayMusic.musicLessTime;
            count = 0;
        }
    }

    private static void time2() {
        try {
            if (PlayMusic.lyric == null) {
                return;
            }
            boolean res = PlayMusic.lyric.checkTime(PlayMusic.musicNowTime, AllMusic.getConfig().ktvMode);
            if (res) {
                times = 0;
                HudUtils.sendHudLyricData();
                AllMusic.side.updateLyric();
            } else if (++times == AllMusic.getConfig().sendDelay / 2 && PlayMusic.lyric != null) {
                times = 0;
                HudUtils.sendHudLyricData();
                AllMusic.side.updateLyric();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static boolean checkPush() {
        SongInfoObj music = PlayMusic.getPush();
        if (music != null) {
            if (PlayMusic.nowPlayMusic.getID().equalsIgnoreCase(music.getID())) {
                return false;
            }
            List<SongInfoObj> list = PlayMusic.getList();
            if (list.isEmpty()) {
                return false;
            }
            SongInfoObj id1 = list.get(0);
            if (id1 != null && id1.getID().equalsIgnoreCase(music.getID())) {
                return false;
            }
            for (int a = 1; a < list.size(); ++a) {
                id1 = list.get(a);
                if (!id1.getID().equalsIgnoreCase(music.getID())) continue;
                return true;
            }
        }
        return false;
    }

    private static void time3() {
        try {
            int players;
            if (++ping >= 10) {
                AllMusic.side.ping();
            }
            if (PlayMusic.getPushTime() > 0) {
                if (!PlayRuntime.checkPush()) {
                    PlayMusic.clearPush();
                    AllMusic.side.broadcastInTask(AllMusic.getMessage().push.cancel);
                } else {
                    PlayMusic.pushTick();
                    if (PlayMusic.getPushTime() == 0) {
                        PlayMusic.clearPush();
                        AllMusic.side.broadcastInTask(AllMusic.getMessage().push.timeOut);
                    } else {
                        players = AllMusic.side.getPlayers().size();
                        if (PlayMusic.getPushCount() >= AllMusic.getConfig().minVote || players <= AllMusic.getConfig().minVote && players <= PlayMusic.getPushCount()) {
                            PlayMusic.pushMusic();
                            PlayMusic.clearPush();
                            AllMusic.side.broadcastInTask(AllMusic.getMessage().push.doPush);
                        }
                    }
                }
            }
            if (PlayMusic.getVoteTime() > 0) {
                PlayMusic.voteTick();
                if (PlayMusic.getVoteTime() == 0) {
                    PlayMusic.clearVote();
                    AllMusic.side.broadcastInTask(AllMusic.getMessage().vote.timeOut);
                } else {
                    players = AllMusic.side.getPlayers().size();
                    if (PlayMusic.getVoteCount() >= AllMusic.getConfig().minVote || players <= AllMusic.getConfig().minVote && players <= PlayMusic.getVoteCount()) {
                        PlayMusic.musicLessTime = 0L;
                        PlayMusic.clearVote();
                        AllMusic.side.broadcastInTask(AllMusic.getMessage().vote.voteDone);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void task() {
        while (isRun) {
            try {
                String data;
                if (PlayMusic.getListSize() == 0) {
                    String id;
                    if (PlayMusic.error >= 10) {
                        Thread.sleep(1000L);
                    } else if (AllMusic.side.needPlay(true) && PlayMusic.getIdleListSize() > 0 && (id = PlayMusic.getIdleMusic()) != null) {
                        PlayMusic.addMusic(null, id, AllMusic.getMessage().custom.idle, true);
                    }
                    Thread.sleep(1000L);
                    continue;
                }
                HudUtils.sendHudNowData();
                HudUtils.sendHudLyricData();
                HudUtils.sendHudListData();
                AllMusic.side.sendHudUtilsAll();
                PlayMusic.nowPlayMusic = PlayMusic.remove(0);
                if (AllMusic.side.onMusicPlay(PlayMusic.nowPlayMusic)) {
                    AllMusic.side.broadcastInTask(AllMusic.getMessage().musicPlay.cancel);
                    continue;
                }
                String string = PlayMusic.url = PlayMusic.nowPlayMusic.getPlayerUrl() == null ? AllMusic.getMusicApi().getPlayUrl(PlayMusic.nowPlayMusic.getID()) : PlayMusic.nowPlayMusic.getPlayerUrl();
                if (PlayMusic.url == null) {
                    data = AllMusic.getMessage().musicPlay.emptyCanPlay;
                    AllMusic.side.broadcastInTask(data.replace(ARG.musicId, PlayMusic.nowPlayMusic.getID()));
                    PlayMusic.nowPlayMusic = null;
                    continue;
                }
                PlayMusic.lyric = PlayMusic.nowPlayMusic.getPlayerUrl() == null ? AllMusic.getMusicApi().getLyric(PlayMusic.nowPlayMusic.getID()) : new LyricSave();
                if (PlayMusic.nowPlayMusic.getLength() != 0L) {
                    PlayMusic.musicAllTime = PlayMusic.musicLessTime = PlayMusic.nowPlayMusic.getLength() / 1000L + 3L;
                    PlayRuntime.startTimer();
                    AllMusic.side.sendMusic(PlayMusic.url);
                    if (!AllMusic.getConfig().mutePlayMessage) {
                        String info;
                        SongInfoObj music = PlayMusic.nowPlayMusic;
                        if (AllMusic.getConfig().showInBar) {
                            info = AllMusic.getMessage().musicPlay.nowPlay.replace(ARG.musicName, HudUtils.messageLimit(music.getName())).replace(ARG.musicAuthor, HudUtils.messageLimit(music.getAuthor())).replace(ARG.musicAl, HudUtils.messageLimit(music.getAl())).replace(ARG.musicAlia, HudUtils.messageLimit(music.getAlia())).replace(ARG.player, music.getCall());
                            AllMusic.side.sendBar(info);
                        } else {
                            info = AllMusic.getMessage().musicPlay.nowPlay.replace(ARG.musicName, music.getName()).replace(ARG.musicAuthor, music.getAuthor()).replace(ARG.musicAl, music.getAl()).replace(ARG.musicAlia, music.getAlia()).replace(ARG.player, music.getCall());
                            AllMusic.side.broadcastInTask(info);
                        }
                    }
                    if (!PlayMusic.nowPlayMusic.isUrl() && PlayMusic.nowPlayMusic.getPicUrl() != null) {
                        AllMusic.side.sendPic(PlayMusic.nowPlayMusic.getPicUrl());
                    }
                    if (PlayMusic.nowPlayMusic.isTrial()) {
                        AllMusic.side.broadcastInTask(AllMusic.getMessage().musicPlay.trail);
                        PlayMusic.musicLessTime = PlayMusic.nowPlayMusic.getTrialInfo().getEnd();
                        PlayMusic.musicNowTime = PlayMusic.nowPlayMusic.getTrialInfo().getStart();
                    }
                    AllMusic.side.updateInfo();
                    while (PlayMusic.musicLessTime > 0L) {
                        HudUtils.sendHudNowData();
                        HudUtils.sendHudListData();
                        if (PlayMusic.nowPlayMusic == null || !AllMusic.side.needPlay(PlayMusic.nowPlayMusic.isList())) {
                            PlayMusic.musicLessTime = 1L;
                        }
                        Thread.sleep(AllMusic.getConfig().sendDelay);
                    }
                    AllMusic.side.sendStop();
                } else {
                    data = AllMusic.getMessage().musicPlay.emptyCanPlay;
                    AllMusic.side.broadcastInTask(data.replace(ARG.musicId, PlayMusic.nowPlayMusic.getID()));
                }
                PlayRuntime.clear();
            }
            catch (Exception e) {
                AllMusic.log.warning("\u00a7c\u6b4c\u66f2\u64ad\u653e\u51fa\u73b0\u9519\u8bef");
                e.printStackTrace();
            }
        }
    }

    static {
        times = 0;
    }
}

