/*
 * Decompiled with CFR 0.152.
 */
package com.coloryr.allmusic.server.core.music.play;

import com.coloryr.allmusic.server.core.AllMusic;
import com.coloryr.allmusic.server.core.music.api.APIMain;
import com.coloryr.allmusic.server.core.music.play.LyricSave;
import com.coloryr.allmusic.server.core.objs.config.LimitObj;
import com.coloryr.allmusic.server.core.objs.message.ARG;
import com.coloryr.allmusic.server.core.objs.music.MusicObj;
import com.coloryr.allmusic.server.core.objs.music.SongInfoObj;
import com.coloryr.allmusic.server.core.sql.DataSql;
import com.coloryr.allmusic.server.core.utils.HudUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;

public class PlayMusic {
    private static final List<SongInfoObj> playList = new ArrayList<SongInfoObj>();
    private static final Queue<MusicObj> tasks = new ConcurrentLinkedQueue<MusicObj>();
    private static final Queue<String> deep = new PriorityQueue<String>();
    private static final Set<String> votePlayer = new HashSet<String>();
    private static final Set<String> pushPlayer = new HashSet<String>();
    public static long musicAllTime = 0L;
    public static long musicLessTime = 0L;
    public static long musicNowTime = 0L;
    public static SongInfoObj nowPlayMusic;
    public static LyricSave lyric;
    public static String url;
    public static int error;
    private static int voteTime;
    private static String voteSender;
    private static int pushTime;
    private static String pushSender;
    private static SongInfoObj push;
    private static boolean isRun;
    private static int idleNow;

    public static void stop() {
        PlayMusic.clear();
        isRun = false;
    }

    public static void start() {
        Thread addT = new Thread(PlayMusic::task, "AllMusicList");
        isRun = true;
        addT.start();
    }

    public static void addVote(String player) {
        player = player.toLowerCase();
        votePlayer.add(player);
    }

    public static void startVote(String player) {
        voteSender = player = player.toLowerCase();
        votePlayer.add(player);
        voteTime = AllMusic.getConfig().voteTime;
    }

    public static void addPush(String player) {
        player = player.toLowerCase();
        pushPlayer.add(player);
    }

    public static void startPush(String player, SongInfoObj music) {
        player = player.toLowerCase();
        push = music;
        pushSender = player;
        pushPlayer.add(player);
        pushTime = AllMusic.getConfig().voteTime;
    }

    public static void pushTick() {
        --pushTime;
    }

    public static void voteTick() {
        --voteTime;
    }

    public static SongInfoObj getPush() {
        return push;
    }

    public static int getPushTime() {
        return pushTime;
    }

    public static String getPushSender() {
        return pushSender;
    }

    public static int getVoteTime() {
        return voteTime;
    }

    public static String getVoteSender() {
        return voteSender;
    }

    public static int getVoteCount() {
        return votePlayer.size();
    }

    public static int getPushCount() {
        return pushPlayer.size();
    }

    public static void clearVote() {
        voteTime = -1;
        voteSender = null;
        votePlayer.clear();
    }

    public static void clearPush() {
        pushTime = -1;
        push = null;
        pushSender = null;
        pushPlayer.clear();
    }

    public static boolean containVote(String player) {
        player = player.toLowerCase();
        return votePlayer.contains(player);
    }

    public static boolean containPush(String player) {
        player = player.toLowerCase();
        return pushPlayer.contains(player);
    }

    public static void addTask(MusicObj obj2) {
        tasks.add(obj2);
    }

    private static void task() {
        while (isRun) {
            try {
                MusicObj obj2 = tasks.poll();
                if (obj2 != null) {
                    if (obj2.isUrl) {
                        PlayMusic.addUrl(obj2.url);
                    } else {
                        PlayMusic.addMusic(obj2.sender, obj2.id, obj2.name, obj2.isDefault);
                    }
                }
                Thread.sleep(10L);
            }
            catch (Exception e) {
                AllMusic.log.warning("\u6b4c\u66f2\u5904\u7406\u51fa\u73b0\u95ee\u9898");
                e.printStackTrace();
            }
        }
    }

    public static void addMusic(Object sender, String id, String player, boolean isList) {
        if (PlayMusic.haveMusic(id)) {
            return;
        }
        if (sender != null) {
            String text = AllMusic.getMessage().musicPlay.checkMusic.replace(ARG.musicId, id);
            AllMusic.side.sendMessageTask(sender, text);
        }
        AllMusic.log.info("\u73a9\u5bb6\uff1a" + player + " \u70b9\u6b4c\uff1a" + id);
        try {
            SongInfoObj info = AllMusic.getMusicApi().getMusic(id, player, isList);
            if (info == null) {
                if (sender != null) {
                    String data = AllMusic.getMessage().musicPlay.emptyCanPlay;
                    AllMusic.side.sendMessageTask(sender, data.replace(ARG.musicId, id));
                }
                return;
            }
            LimitObj limit = AllMusic.getConfig().limit;
            if (limit.musicTimeLimit && info.getLength() / 1000L > (long)limit.maxMusicTime) {
                if (sender != null) {
                    AllMusic.side.sendMessageTask(sender, AllMusic.getMessage().addMusic.timeOut);
                }
                return;
            }
            playList.add(info);
            if (!AllMusic.getConfig().muteAddMessage) {
                if (AllMusic.getConfig().showInBar) {
                    String data = AllMusic.getMessage().musicPlay.addMusic.replace(ARG.musicName, HudUtils.messageLimit(info.getName())).replace(ARG.musicAuthor, HudUtils.messageLimit(info.getAuthor())).replace(ARG.musicAl, HudUtils.messageLimit(info.getAl())).replace(ARG.musicAlia, HudUtils.messageLimit(info.getAlia())).replace(ARG.player, info.getCall());
                    AllMusic.side.sendBar(data);
                } else {
                    String data = AllMusic.getMessage().musicPlay.addMusic.replace(ARG.musicName, info.getName()).replace(ARG.musicAuthor, info.getAuthor()).replace(ARG.musicAl, info.getAl()).replace(ARG.musicAlia, info.getAlia()).replace(ARG.player, info.getCall());
                    AllMusic.side.broadcastInTask(data);
                }
            }
            if (AllMusic.getConfig().playListSwitch && nowPlayMusic != null && nowPlayMusic.isList()) {
                musicLessTime = 1L;
                if (!isList) {
                    AllMusic.side.broadcastInTask(AllMusic.getMessage().musicPlay.switchMusic);
                }
            }
            error = 0;
        }
        catch (Exception e) {
            if (isList) {
                ++error;
            }
            AllMusic.log.warning("\u00a7d[AllMusic3]\u00a7c\u6b4c\u66f2\u4fe1\u606f\u89e3\u6790\u9519\u8bef");
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pushMusic() {
        SongInfoObj obj2 = push;
        List<SongInfoObj> list = playList;
        synchronized (list) {
            playList.remove(obj2);
            playList.add(0, obj2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getListSize() {
        List<SongInfoObj> list = playList;
        synchronized (list) {
            return playList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<SongInfoObj> getList() {
        List<SongInfoObj> list = playList;
        synchronized (list) {
            return new ArrayList<SongInfoObj>(playList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        List<SongInfoObj> list = playList;
        synchronized (list) {
            playList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SongInfoObj remove(int index) {
        List<SongInfoObj> list = playList;
        synchronized (list) {
            return playList.remove(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(SongInfoObj index) {
        List<SongInfoObj> list = playList;
        synchronized (list) {
            playList.remove(index);
        }
    }

    public static String getAllList() {
        StringBuilder list = new StringBuilder();
        for (int i = 0; i < playList.size(); ++i) {
            SongInfoObj info = playList.get(i);
            String a = AllMusic.getMessage().musicPlay.listMusic.item;
            a = a.replace(ARG.index, String.valueOf(i + 1)).replace(ARG.musicName, info.getName()).replace(ARG.musicAuthor, info.getAuthor()).replace(ARG.musicAl, info.getAl()).replace(ARG.musicAlia, info.getAlia());
            list.append(a).append("\n");
        }
        String temp = list.toString();
        if (temp.isEmpty()) {
            return "";
        }
        return temp.substring(0, temp.length() - 1);
    }

    public static boolean haveMusic(String id) {
        if (nowPlayMusic != null && nowPlayMusic.getID().equalsIgnoreCase(id)) {
            return true;
        }
        for (SongInfoObj item : playList) {
            if (!item.getID().equalsIgnoreCase(id)) continue;
            return true;
        }
        return false;
    }

    private static void addUrl(String url) {
        SongInfoObj info = APIMain.getUrlMusic(url);
        if (info == null) {
            AllMusic.side.broadcastInTask(AllMusic.getMessage().musicPlay.error1);
            return;
        }
        info.setName(AllMusic.getMessage().custom.info);
        playList.add(info);
    }

    public static boolean isPlayerMax(String name) {
        int list = AllMusic.getConfig().maxPlayerList;
        if (list == 0) {
            return false;
        }
        int count = 0;
        for (MusicObj obj2 : tasks) {
            if (!obj2.name.equalsIgnoreCase(name)) continue;
            ++count;
        }
        return list <= count;
    }

    public static void clearIdleList() {
        deep.clear();
        DataSql.clearIdleList();
    }

    public static int getIdleListSize() {
        return DataSql.getListSize();
    }

    public static String getIdleMusic() {
        String id;
        if (AllMusic.getMusicApi().isUpdate()) {
            return null;
        }
        int len = DataSql.getListSize();
        if (len == 0) {
            return null;
        }
        if (AllMusic.getConfig().playListRandom) {
            if (len == 1) {
                return DataSql.readListItem();
            }
            if (len > 10) {
                int size = AllMusic.getConfig().playListEscapeDeep;
                if (size > len / 2) {
                    size = len / 2;
                }
                while (deep.size() >= size) {
                    deep.poll();
                }
                while (deep.contains(id = DataSql.readListItem())) {
                }
                deep.add(id);
            } else {
                id = DataSql.readListItem();
            }
        } else {
            id = DataSql.readListItem(idleNow);
            if (++idleNow >= len) {
                idleNow = 0;
            }
        }
        return id;
    }

    public static SongInfoObj findPlayerMusic(String name) {
        List<SongInfoObj> list1 = PlayMusic.getList();
        for (int a = 0; a < playList.size(); ++a) {
            SongInfoObj item = list1.get(a);
            if (!name.equalsIgnoreCase(item.getCall())) continue;
            return item;
        }
        return null;
    }

    public static SongInfoObj findMusicIndex(int index) {
        List<SongInfoObj> list1 = PlayMusic.getList();
        if (--index <= 0) {
            return null;
        }
        if (list1.size() <= index) {
            return null;
        }
        return list1.get(index);
    }

    static {
        voteTime = 0;
        pushTime = 0;
    }
}

