/*
 * Decompiled with CFR 0.152.
 */
package com.coloryr.allmusic.server.core.music.play;

import com.coloryr.allmusic.server.core.AllMusic;
import com.coloryr.allmusic.server.core.objs.SearchMusicObj;
import com.coloryr.allmusic.server.core.objs.message.ARG;
import com.coloryr.allmusic.server.core.objs.music.MusicObj;
import com.coloryr.allmusic.server.core.objs.music.SearchPageObj;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class MusicSearch {
    private static final Queue<MusicObj> tasks = new ConcurrentLinkedQueue<MusicObj>();
    private static boolean isRun;

    private static void task() {
        while (isRun) {
            try {
                MusicObj obj2 = tasks.poll();
                if (obj2 != null) {
                    SearchPageObj search = AllMusic.getMusicApi().search(obj2.args, obj2.isDefault);
                    if (search == null) {
                        AllMusic.side.sendMessageTask(obj2.sender, AllMusic.getMessage().search.cantSearch.replace(ARG.name, obj2.isDefault ? obj2.args[0] : obj2.args[1]));
                    } else {
                        AllMusic.side.sendMessageTask(obj2.sender, AllMusic.getMessage().search.res);
                        AllMusic.addSearch(obj2.name, search);
                        AllMusic.side.runTask(() -> MusicSearch.showSearch(obj2.sender, search));
                    }
                }
                Thread.sleep(100L);
            }
            catch (Exception e) {
                AllMusic.log.warning("\u641c\u6b4c\u51fa\u73b0\u95ee\u9898");
                e.printStackTrace();
            }
        }
    }

    public static void start() {
        Thread taskT = new Thread(MusicSearch::task, "AllMusic_search");
        isRun = true;
        taskT.start();
    }

    public static void stop() {
        isRun = false;
    }

    public static void addSearch(MusicObj obj2) {
        tasks.add(obj2);
    }

    public static void showSearch(Object sender, SearchPageObj search) {
        int index = search.getIndex();
        AllMusic.side.sendMessage(sender, "");
        if (search.haveLastPage()) {
            AllMusic.side.sendMessageRun(sender, "\u00a7d[AllMusic3]\u00a72\u8f93\u5165/music lastpage\u4e0a\u4e00\u9875", AllMusic.getMessage().page.last, "/music lastpage");
        }
        for (int a = 0; a < index; ++a) {
            SearchMusicObj item = search.getRes(a + search.getPage() * 10);
            String info = AllMusic.getMessage().page.choice;
            info = info.replace(ARG.index, "" + (a + 1)).replace(ARG.musicName, item.name).replace(ARG.musicAuthor, item.author).replace(ARG.musicAl, item.al);
            AllMusic.side.sendMessageRun(sender, info, AllMusic.getMessage().click.clickRun, "/music select " + (a + 1));
        }
        if (search.haveNextPage()) {
            AllMusic.side.sendMessageRun(sender, "\u00a7d[AllMusic3]\u00a72\u8f93\u5165/music nextpage\u4e0b\u4e00\u9875", AllMusic.getMessage().page.next, "/music nextpage");
        }
        AllMusic.side.sendMessage(sender, "");
    }
}

