/*
 * Decompiled with CFR 0.152.
 */
package com.coloryr.allmusic.server.core.music.api;

import com.coloryr.allmusic.server.core.AllMusic;
import com.coloryr.allmusic.server.core.decoder.flac.FlacDecoder;
import com.coloryr.allmusic.server.core.decoder.flac.StreamInfo;
import com.coloryr.allmusic.server.core.decoder.mp3.Bitstream;
import com.coloryr.allmusic.server.core.decoder.mp3.Header;
import com.coloryr.allmusic.server.core.music.api.HttpClientUtil;
import com.coloryr.allmusic.server.core.music.play.LyricDo;
import com.coloryr.allmusic.server.core.music.play.LyricSave;
import com.coloryr.allmusic.server.core.objs.HttpResObj;
import com.coloryr.allmusic.server.core.objs.MediaType;
import com.coloryr.allmusic.server.core.objs.SearchMusicObj;
import com.coloryr.allmusic.server.core.objs.api.music.info.InfoObj;
import com.coloryr.allmusic.server.core.objs.api.music.list.DataObj;
import com.coloryr.allmusic.server.core.objs.api.music.lyric.WLyricObj;
import com.coloryr.allmusic.server.core.objs.api.music.search.SearchDataObj;
import com.coloryr.allmusic.server.core.objs.api.music.search.songs;
import com.coloryr.allmusic.server.core.objs.api.music.trialinfo.TrialInfoObj;
import com.coloryr.allmusic.server.core.objs.api.program.info.PrInfoObj;
import com.coloryr.allmusic.server.core.objs.enums.EncryptType;
import com.coloryr.allmusic.server.core.objs.message.ARG;
import com.coloryr.allmusic.server.core.objs.music.SearchPageObj;
import com.coloryr.allmusic.server.core.objs.music.SongInfoObj;
import com.coloryr.allmusic.server.core.sql.DataSql;
import com.coloryr.allmusic.server.lib.com.google.gson.JsonObject;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class APIMain {
    private boolean isUpdate;

    public APIMain() {
        AllMusic.log.info("\u00a7d[AllMusic3]\u00a7e\u6b63\u5728\u521d\u59cb\u5316\u7f51\u7edc\u722c\u866b");
        HttpClientUtil.init();
        HttpResObj res = HttpClientUtil.get("https://music.163.com", "");
        if (res == null || !res.ok) {
            AllMusic.log.info("\u00a7d[AllMusic3]\u00a7c\u521d\u59cb\u5316\u7f51\u7edc\u722c\u866b\u8fde\u63a5\u5931\u8d25");
        }
    }

    public boolean isUpdate() {
        return this.isUpdate;
    }

    private SongInfoObj getMusicDetail(String id, String player, boolean isList) {
        InfoObj temp;
        JsonObject params = new JsonObject();
        params.addProperty("c", "[{\"id\":" + id + "}]");
        HttpResObj res = HttpClientUtil.post("https://music.163.com/api/v3/song/detail", params, EncryptType.WEAPI, null);
        if (res != null && res.ok && (temp = AllMusic.gson.fromJson(res.data, InfoObj.class)).isOk()) {
            params = new JsonObject();
            params.addProperty("ids", "[" + id + "]");
            params.addProperty("br", "320000");
            res = HttpClientUtil.post("https://music.163.com/weapi/song/enhance/player/url", params, EncryptType.WEAPI, null);
            if (res == null || !res.ok) {
                AllMusic.log.warning("\u00a7d[AllMusic3]\u00a7c\u7248\u6743\u68c0\u7d22\u5931\u8d25");
                return null;
            }
            TrialInfoObj obj2 = AllMusic.gson.fromJson(res.data, TrialInfoObj.class);
            return new SongInfoObj(temp.getAuthor(), temp.getName(), id, temp.getAlia(), player, temp.getAl(), isList, temp.getLength(), temp.getPicUrl(), obj2.isTrial(), obj2.getFreeTrialInfo());
        }
        return null;
    }

    public SongInfoObj getMusic(String id, String player, boolean isList) {
        SongInfoObj info = this.getMusicDetail(id, player, isList);
        if (info != null) {
            return info;
        }
        JsonObject params = new JsonObject();
        params.addProperty("id", id);
        HttpResObj res = HttpClientUtil.post("https://music.163.com/api/dj/program/detail", params, EncryptType.WEAPI, null);
        if (res != null && res.ok) {
            PrInfoObj temp = AllMusic.gson.fromJson(res.data, PrInfoObj.class);
            if (temp.isOk()) {
                return new SongInfoObj(temp.getAuthor(), temp.getName(), temp.getId(), temp.getAlia(), player, "\u7535\u53f0", isList, temp.getLength(), null, false, null);
            }
            AllMusic.log.warning("\u00a7d[AllMusic3]\u00a7c\u6b4c\u66f2\u4fe1\u606f\u83b7\u53d6\u4e3a\u7a7a");
        }
        return info;
    }

    public String getPlayUrl(String id) {
        JsonObject params = new JsonObject();
        params.addProperty("ids", "[" + id + "]");
        params.addProperty("br", AllMusic.getConfig().musicBR);
        HttpResObj res = HttpClientUtil.post("https://music.163.com/weapi/song/enhance/player/url", params, EncryptType.WEAPI, null);
        if (res != null && res.ok) {
            try {
                TrialInfoObj obj2 = AllMusic.gson.fromJson(res.data, TrialInfoObj.class);
                return obj2.getUrl();
            }
            catch (Exception e) {
                AllMusic.log.warning("\u00a7d[AllMusic3]\u00a7c\u64ad\u653e\u8fde\u63a5\u89e3\u6790\u9519\u8bef\uff1a" + res.data);
                e.printStackTrace();
            }
        }
        return null;
    }

    public void setList(String id, Object sender) {
        Thread thread2 = new Thread(() -> {
            JsonObject params = new JsonObject();
            params.addProperty("id", id);
            params.addProperty("n", 100000);
            params.addProperty("s", 8);
            HttpResObj res = HttpClientUtil.post("https://music.163.com/api/v6/playlist/detail", params, EncryptType.API, null);
            if (res != null && res.ok) {
                try {
                    this.isUpdate = true;
                    DataObj obj2 = AllMusic.gson.fromJson(res.data, DataObj.class);
                    DataSql.addIdleList(obj2.getPlaylist());
                    AllMusic.side.sendMessageTask(sender, AllMusic.getMessage().musicPlay.listMusic.get.replace(ARG.name, obj2.getName()));
                }
                catch (Exception e) {
                    AllMusic.log.warning("\u00a7d[AllMusic3]\u00a7c\u6b4c\u66f2\u5217\u8868\u83b7\u53d6\u9519\u8bef");
                    e.printStackTrace();
                }
            }
            this.isUpdate = false;
        }, "AllMusic_setList");
        thread2.start();
    }

    public LyricSave getLyric(String id) {
        LyricSave lyric = new LyricSave();
        JsonObject params = new JsonObject();
        params.addProperty("id", id);
        params.addProperty("cp", false);
        params.addProperty("tv", 0);
        params.addProperty("lv", 0);
        params.addProperty("rv", 0);
        params.addProperty("kv", 0);
        params.addProperty("yv", 0);
        params.addProperty("ytv", 0);
        params.addProperty("rtv", 0);
        HttpResObj res = HttpClientUtil.post("https://interface3.music.163.com/eapi/song/lyric/v1", params, EncryptType.EAPI, "/api/song/lyric/v1");
        if (res != null && res.ok) {
            try {
                WLyricObj obj2 = AllMusic.gson.fromJson(res.data, WLyricObj.class);
                LyricDo temp = new LyricDo();
                for (int times = 0; times < 3; ++times) {
                    if (!temp.check(obj2)) {
                        if (temp.isHave) {
                            lyric.setHaveLyric(AllMusic.getConfig().sendLyric);
                            lyric.setLyric(temp.getTemp());
                            if (temp.isHaveK) {
                                lyric.setKlyric(temp.getKLyric());
                            }
                        }
                        return lyric;
                    }
                    AllMusic.log.warning("\u00a7d[AllMusic3]\u00a7c\u6b4c\u8bcd\u89e3\u6790\u9519\u8bef\uff0c\u6b63\u5728\u8fdb\u884c\u7b2c" + times + "\u91cd\u8bd5");
                    Thread.sleep(1000L);
                }
                AllMusic.log.warning("\u00a7d[AllMusic3]\u00a7c\u6b4c\u8bcd\u89e3\u6790\u5931\u8d25");
            }
            catch (Exception e) {
                AllMusic.log.warning("\u00a7d[AllMusic3]\u00a7c\u6b4c\u8bcd\u89e3\u6790\u9519\u8bef");
                e.printStackTrace();
            }
        }
        return lyric;
    }

    public SearchPageObj search(String[] name, boolean isDefault) {
        int a;
        ArrayList<SearchMusicObj> resData = new ArrayList<SearchMusicObj>();
        StringBuilder name1 = new StringBuilder();
        int n = a = isDefault ? 0 : 1;
        while (a < name.length) {
            name1.append(name[a]).append(" ");
            ++a;
        }
        String MusicName = name1.toString();
        MusicName = MusicName.substring(0, MusicName.length() - 1);
        JsonObject params = new JsonObject();
        params.addProperty("s", MusicName);
        params.addProperty("type", 1);
        params.addProperty("limit", 30);
        params.addProperty("offset", 0);
        HttpResObj res = HttpClientUtil.post("https://music.163.com/weapi/search/get", params, EncryptType.WEAPI, null);
        if (res != null && res.ok) {
            SearchDataObj obj2 = AllMusic.gson.fromJson(res.data, SearchDataObj.class);
            if (obj2 != null && obj2.isOk()) {
                List<songs> res1 = obj2.getResult();
                for (songs temp : res1) {
                    SearchMusicObj item = new SearchMusicObj(String.valueOf(temp.getId()), temp.getName(), temp.getArtists(), temp.getAlbum());
                    resData.add(item);
                }
                int maxpage = res1.size() / 10;
                return new SearchPageObj(resData, maxpage);
            }
            AllMusic.log.warning("\u00a7d[AllMusic3]\u00a7c\u6b4c\u66f2\u641c\u7d22\u51fa\u73b0\u9519\u8bef");
        }
        return null;
    }

    private static int toUnsignedInt(byte x) {
        return x & 0xFF;
    }

    private static MediaType testMediaType(BufferedInputStream stream) throws IOException {
        stream.mark(10);
        byte[] temp = new byte[4];
        int res = stream.read(temp);
        if (res != 4) {
            return MediaType.Unknow;
        }
        if (temp[0] == 82 && temp[1] == 73 && temp[2] == 70 && temp[3] == 70) {
            return MediaType.Wav;
        }
        if (temp[0] == 102 && temp[1] == 76 && temp[2] == 97 && temp[3] == 67) {
            return MediaType.Flac;
        }
        if (temp[0] == 73 && temp[1] == 68 && temp[2] == 51) {
            return MediaType.Mp3;
        }
        if (APIMain.toUnsignedInt(temp[0]) == 255 && APIMain.toUnsignedInt(temp[1]) == 224) {
            return MediaType.Mp3;
        }
        return MediaType.Unknow;
    }

    public static SongInfoObj getUrlMusic(String url) {
        try {
            InputStream stream = HttpClientUtil.get(url);
            if (stream == null) {
                return null;
            }
            BufferedInputStream in = new BufferedInputStream(stream);
            MediaType type = APIMain.testMediaType(in);
            in.reset();
            float le = 0.0f;
            if (type == MediaType.Mp3) {
                Header h2;
                Bitstream bt = new Bitstream(in);
                bt.readFrame();
                bt.closeFrame();
                while ((h2 = bt.readFrame()) != null) {
                    bt.closeFrame();
                    le += h2.ms_per_frame();
                }
                bt.close();
                return new SongInfoObj(null, url, (int)le, type);
            }
            if (type == MediaType.Flac) {
                Object temp;
                FlacDecoder flac = new FlacDecoder(in);
                while (!((temp = flac.readAndHandleMetadataBlock()) instanceof StreamInfo)) {
                }
                StreamInfo info = (StreamInfo)temp;
                le = (float)info.numSamples / (float)info.sampleRate;
                flac.close();
                return new SongInfoObj(null, url, (int)le, type);
            }
        }
        catch (Exception e) {
            AllMusic.log.warning("\u00a7d[AllMusic3]\u00a7c\u6b4c\u66f2\u957f\u5ea6\u89e3\u6790\u9519\u8bef");
            e.printStackTrace();
        }
        return null;
    }
}

