/*
 * Decompiled with CFR 0.152.
 */
package com.coloryr.allmusic.server.core.decoder.flac;

import com.coloryr.allmusic.server.core.decoder.flac.DataFormatException;
import com.coloryr.allmusic.server.core.decoder.flac.FlacLowLevelInput;
import java.io.IOException;

public final class FrameInfo {
    private static final int[][] BLOCK_SIZE_CODES = new int[][]{{192, 1}, {576, 2}, {1152, 3}, {2304, 4}, {4608, 5}, {256, 8}, {512, 9}, {1024, 10}, {2048, 11}, {4096, 12}, {8192, 13}, {16384, 14}, {32768, 15}};
    private static final int[][] SAMPLE_DEPTH_CODES = new int[][]{{8, 1}, {12, 2}, {16, 4}, {20, 5}, {24, 6}};
    private static final int[][] SAMPLE_RATE_CODES = new int[][]{{88200, 1}, {176400, 2}, {192000, 3}, {8000, 4}, {16000, 5}, {22050, 6}, {24000, 7}, {32000, 8}, {44100, 9}, {48000, 10}, {96000, 11}};
    public int frameIndex = -1;
    public long sampleOffset = -1L;
    public int numChannels = -1;
    public int channelAssignment = -1;
    public int blockSize = -1;
    public int sampleRate = -1;
    public int sampleDepth = -1;
    public int frameSize = -1;

    public static FrameInfo readFrame(FlacLowLevelInput in) throws IOException {
        int chanAsgn;
        in.resetCrcs();
        int temp = in.readByte();
        if (temp == -1) {
            return null;
        }
        FrameInfo result2 = new FrameInfo();
        result2.frameSize = -1;
        int sync = temp << 6 | in.readUint(6);
        if (sync != 16382) {
            throw new DataFormatException("Sync code expected");
        }
        if (in.readUint(1) != 0) {
            throw new DataFormatException("Reserved bit");
        }
        int blockStrategy = in.readUint(1);
        int blockSizeCode = in.readUint(4);
        int sampleRateCode = in.readUint(4);
        result2.channelAssignment = chanAsgn = in.readUint(4);
        if (chanAsgn < 8) {
            result2.numChannels = chanAsgn + 1;
        } else if (8 <= chanAsgn && chanAsgn <= 10) {
            result2.numChannels = 2;
        } else {
            throw new DataFormatException("Reserved channel assignment");
        }
        result2.sampleDepth = FrameInfo.decodeSampleDepth(in.readUint(3));
        if (in.readUint(1) != 0) {
            throw new DataFormatException("Reserved bit");
        }
        long position = FrameInfo.readUtf8Integer(in);
        if (blockStrategy == 0) {
            if (position >>> 31 != 0L) {
                throw new DataFormatException("Frame index too large");
            }
            result2.frameIndex = (int)position;
            result2.sampleOffset = -1L;
        } else if (blockStrategy == 1) {
            result2.sampleOffset = position;
            result2.frameIndex = -1;
        } else {
            throw new AssertionError();
        }
        result2.blockSize = FrameInfo.decodeBlockSize(blockSizeCode, in);
        result2.sampleRate = FrameInfo.decodeSampleRate(sampleRateCode, in);
        int computedCrc8 = in.getCrc8();
        if (in.readUint(8) != computedCrc8) {
            throw new DataFormatException("CRC-8 mismatch");
        }
        return result2;
    }

    private static long readUtf8Integer(FlacLowLevelInput in) throws IOException {
        int head = in.readUint(8);
        int n = Integer.numberOfLeadingZeros(~(head << 24));
        assert (0 <= n && n <= 8);
        if (n == 0) {
            return head;
        }
        if (n == 1 || n == 8) {
            throw new DataFormatException("Invalid UTF-8 coded number");
        }
        long result2 = head & 127 >>> n;
        for (int i = 0; i < n - 1; ++i) {
            int temp = in.readUint(8);
            if ((temp & 0xC0) != 128) {
                throw new DataFormatException("Invalid UTF-8 coded number");
            }
            result2 = result2 << 6 | (long)(temp & 0x3F);
        }
        if (result2 >>> 36 != 0L) {
            throw new AssertionError();
        }
        return result2;
    }

    private static int decodeBlockSize(int code, FlacLowLevelInput in) throws IOException {
        if (code >>> 4 != 0) {
            throw new IllegalArgumentException();
        }
        switch (code) {
            case 0: {
                throw new DataFormatException("Reserved block size");
            }
            case 6: {
                return in.readUint(8) + 1;
            }
            case 7: {
                return in.readUint(16) + 1;
            }
        }
        int result2 = FrameInfo.searchSecond(BLOCK_SIZE_CODES, code);
        if (result2 < 1 || result2 > 65536) {
            throw new AssertionError();
        }
        return result2;
    }

    private static int decodeSampleRate(int code, FlacLowLevelInput in) throws IOException {
        if (code >>> 4 != 0) {
            throw new IllegalArgumentException();
        }
        switch (code) {
            case 0: {
                return -1;
            }
            case 12: {
                return in.readUint(8);
            }
            case 13: {
                return in.readUint(16);
            }
            case 14: {
                return in.readUint(16) * 10;
            }
            case 15: {
                throw new DataFormatException("Invalid sample rate");
            }
        }
        int result2 = FrameInfo.searchSecond(SAMPLE_RATE_CODES, code);
        if (result2 < 1 || result2 > 655350) {
            throw new AssertionError();
        }
        return result2;
    }

    private static int decodeSampleDepth(int code) {
        if (code >>> 3 != 0) {
            throw new IllegalArgumentException();
        }
        if (code == 0) {
            return -1;
        }
        int result2 = FrameInfo.searchSecond(SAMPLE_DEPTH_CODES, code);
        if (result2 == -1) {
            throw new DataFormatException("Reserved bit depth");
        }
        if (result2 < 1 || result2 > 32) {
            throw new AssertionError();
        }
        return result2;
    }

    private static int getBlockSizeCode(int blockSize) {
        int result2 = FrameInfo.searchFirst(BLOCK_SIZE_CODES, blockSize);
        if (result2 == -1) {
            if (1 <= blockSize && blockSize <= 256) {
                result2 = 6;
            } else if (1 <= blockSize && blockSize <= 65536) {
                result2 = 7;
            } else {
                throw new IllegalArgumentException();
            }
        }
        if (result2 >>> 4 != 0) {
            throw new AssertionError();
        }
        return result2;
    }

    private static int getSampleRateCode(int sampleRate) {
        if (sampleRate == 0 || sampleRate < -1) {
            throw new IllegalArgumentException();
        }
        int result2 = FrameInfo.searchFirst(SAMPLE_RATE_CODES, sampleRate);
        if (result2 == -1) {
            result2 = 0 <= sampleRate && sampleRate < 256 ? 12 : (0 <= sampleRate && sampleRate < 65536 ? 13 : (0 <= sampleRate && sampleRate < 655360 && sampleRate % 10 == 0 ? 14 : 0));
        }
        if (result2 >>> 4 != 0) {
            throw new AssertionError();
        }
        return result2;
    }

    private static int getSampleDepthCode(int sampleDepth) {
        if (sampleDepth != -1 && (sampleDepth < 1 || sampleDepth > 32)) {
            throw new IllegalArgumentException();
        }
        int result2 = FrameInfo.searchFirst(SAMPLE_DEPTH_CODES, sampleDepth);
        if (result2 == -1) {
            result2 = 0;
        }
        if (result2 >>> 3 != 0) {
            throw new AssertionError();
        }
        return result2;
    }

    private static final int searchFirst(int[][] table, int key) {
        for (int[] pair : table) {
            if (pair[0] != key) continue;
            return pair[1];
        }
        return -1;
    }

    private static final int searchSecond(int[][] table, int key) {
        for (int[] pair : table) {
            if (pair[1] != key) continue;
            return pair[0];
        }
        return -1;
    }
}

