/*
 * Decompiled with CFR 0.152.
 */
package com.coloryr.allmusic.server.core.decoder.flac;

import com.coloryr.allmusic.server.core.decoder.flac.DataFormatException;
import com.coloryr.allmusic.server.core.decoder.flac.FlacLowLevelInput;
import com.coloryr.allmusic.server.core.decoder.flac.SeekTable;
import com.coloryr.allmusic.server.core.decoder.flac.SeekableFileFlacInput;
import com.coloryr.allmusic.server.core.decoder.flac.StreamInfo;
import java.io.BufferedInputStream;
import java.io.IOException;

public final class FlacDecoder
implements AutoCloseable {
    public StreamInfo streamInfo;
    public SeekTable seekTable;
    private FlacLowLevelInput input;
    private long metadataEndPos;

    public FlacDecoder(BufferedInputStream stream) {
        this.input = new SeekableFileFlacInput(stream);
    }

    public Object readAndHandleMetadataBlock() throws IOException {
        if (this.metadataEndPos != -1L) {
            return null;
        }
        boolean last = this.input.readUint(1) != 0;
        int type = this.input.readUint(7);
        int length = this.input.readUint(24);
        byte[] data = new byte[length];
        this.input.readFully(data);
        if (type == 0) {
            if (this.streamInfo != null) {
                throw new DataFormatException("Duplicate stream info metadata block");
            }
            this.streamInfo = new StreamInfo(data);
            return this.streamInfo;
        }
        if (this.streamInfo == null) {
            throw new DataFormatException("Expected stream info metadata block");
        }
        if (type == 3) {
            if (this.seekTable != null) {
                throw new DataFormatException("Duplicate seek table metadata block");
            }
            this.seekTable = new SeekTable(data);
            return this.seekTable;
        }
        if (last) {
            this.metadataEndPos = this.input.getPosition();
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        if (this.input != null) {
            this.streamInfo = null;
            this.seekTable = null;
            this.input.close();
            this.input = null;
        }
    }
}

