/*
 * Decompiled with CFR 0.152.
 */
package com.coloryr.allmusic.server.core.command.sub;

import com.coloryr.allmusic.server.core.AllMusic;
import com.coloryr.allmusic.server.core.command.ACommand;
import com.coloryr.allmusic.server.core.command.AHudCommand;
import com.coloryr.allmusic.server.core.command.ICommand;
import com.coloryr.allmusic.server.core.objs.enums.HudDirType;
import com.coloryr.allmusic.server.core.objs.enums.HudType;
import com.coloryr.allmusic.server.core.objs.hud.PosObj;
import com.coloryr.allmusic.server.core.objs.message.ARG;
import com.coloryr.allmusic.server.core.utils.HudUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CommandHudSet
extends AHudCommand {
    private static final List<String> hud = new ArrayList<String>(){
        {
            this.add("enable");
            this.add("pos");
            this.add("dir");
            this.add("reset");
        }
    };
    private static final List<String> pic = new ArrayList<String>(){
        {
            this.add("size");
            this.add("rotate");
            this.add("speed");
        }
    };
    private static final List<String> info = new ArrayList<String>(){
        {
            this.add("color");
            this.add("shadow");
        }
    };
    private static final List<String> tf = new ArrayList<String>(){
        {
            this.add("true");
            this.add("false");
        }
    };
    private final Map<String, ICommand> commandList = new HashMap<String, ICommand>();

    public CommandHudSet(HudType type) {
        super(type);
        this.commandList.put("enable", new HudEnable(type));
        this.commandList.put("reset", new HudReset(type));
        this.commandList.put("pos", new HudPos(type));
        this.commandList.put("dir", new HudDir(type));
        if (type == HudType.PIC) {
            this.commandList.put("size", new PicSize());
            this.commandList.put("rotate", new PicRotate());
            this.commandList.put("speed", new PicRotateSpeed());
        } else {
            this.commandList.put("color", new HudColor(type));
            this.commandList.put("shadow", new HudShadow(type));
        }
    }

    @Override
    public void execute(Object sender, String name, String[] args2) {
        if (args2.length == 2) {
            AllMusic.side.sendMessage(sender, AllMusic.getMessage().command.error);
        } else {
            ICommand command = this.commandList.get(args2[2]);
            if (command != null) {
                command.execute(sender, name, args2);
            } else {
                AllMusic.side.sendMessage(sender, AllMusic.getMessage().command.error);
            }
        }
    }

    @Override
    public List<String> tab(Object player, String name, String[] args2, int index) {
        if (args2.length == index + 1) {
            ArrayList<String> list = new ArrayList<String>(hud);
            if (this.type == HudType.PIC) {
                list.addAll(pic);
            } else {
                list.addAll(info);
            }
            return list;
        }
        ICommand command = this.commandList.get(args2[index]);
        if (command != null) {
            return command.tab(player, name, args2, index + 1);
        }
        return Collections.emptyList();
    }

    private static class PicRotateSpeed
    extends ACommand {
        private PicRotateSpeed() {
        }

        @Override
        public void execute(Object sender, String name, String[] args2) {
            if (args2.length != 4 || !HudUtils.setPicRotateSpeed(name, args2[3])) {
                AllMusic.side.sendMessage(sender, AllMusic.getMessage().command.error);
                return;
            }
            AllMusic.side.sendMessage(sender, AllMusic.getMessage().hud.picSpeed.replace(ARG.size, args2[3]));
        }
    }

    private static class PicRotate
    extends ACommand {
        private PicRotate() {
        }

        @Override
        public void execute(Object sender, String name, String[] args2) {
            if (args2.length == 3 || args2.length == 4) {
                AllMusic.side.sendMessage(sender, AllMusic.getMessage().hud.picRotate.replace(ARG.state, HudUtils.setPicRotate(name, args2.length == 4 ? args2[3] : null) ? AllMusic.getMessage().hudList.enable : AllMusic.getMessage().hudList.disable));
                return;
            }
            AllMusic.side.sendMessage(sender, AllMusic.getMessage().command.error);
        }

        @Override
        public List<String> tab(Object player, String name, String[] args2, int index) {
            if (args2.length == index + 1) {
                return tf;
            }
            return Collections.emptyList();
        }
    }

    private static class PicSize
    extends ACommand {
        private PicSize() {
        }

        @Override
        public void execute(Object sender, String name, String[] args2) {
            if (args2.length != 4 || !HudUtils.setPicSize(name, args2[3])) {
                AllMusic.side.sendMessage(sender, AllMusic.getMessage().command.error);
                return;
            }
            AllMusic.side.sendMessage(sender, AllMusic.getMessage().hud.picSize.replace(ARG.size, args2[2]));
        }
    }

    private static class HudShadow
    extends AHudCommand {
        public HudShadow(HudType type) {
            super(type);
        }

        @Override
        public void execute(Object sender, String name, String[] args2) {
            if (args2.length == 3 || args2.length == 4) {
                AllMusic.side.sendMessage(sender, AllMusic.getMessage().hud.set3.replace(ARG.hud, AllMusic.getMessage().hudList.getHud(this.type)).replace(ARG.state, HudUtils.setShadow(name, this.type, args2.length == 4 ? args2[3] : null) ? AllMusic.getMessage().hudList.enable : AllMusic.getMessage().hudList.disable));
                return;
            }
            AllMusic.side.sendMessage(sender, AllMusic.getMessage().command.error);
        }

        @Override
        public List<String> tab(Object player, String name, String[] args2, int index) {
            if (args2.length == index + 1) {
                return tf;
            }
            return Collections.emptyList();
        }
    }

    private static class HudColor
    extends AHudCommand {
        public HudColor(HudType type) {
            super(type);
        }

        @Override
        public void execute(Object sender, String name, String[] args2) {
            if (args2.length != 4) {
                AllMusic.side.sendMessage(sender, AllMusic.getMessage().command.error);
                return;
            }
            if (!HudUtils.setColor(name, this.type, args2[3])) {
                AllMusic.side.sendMessage(sender, AllMusic.getMessage().command.error);
                return;
            }
            AllMusic.side.sendMessage(sender, AllMusic.getMessage().hud.set2.replace(ARG.hud, AllMusic.getMessage().hudList.getHud(this.type)).replace(ARG.color, args2[3]));
        }
    }

    private static class HudDir
    extends AHudCommand {
        private static final List<String> dir = new ArrayList<String>(){
            {
                for (HudDirType type : HudDirType.values()) {
                    this.add(type.name());
                }
            }
        };

        public HudDir(HudType type) {
            super(type);
        }

        @Override
        public void execute(Object sender, String name, String[] args2) {
            if (args2.length != 4) {
                AllMusic.side.sendMessage(sender, AllMusic.getMessage().command.error);
                return;
            }
            HudDirType type1 = HudUtils.setDir(name, this.type, args2[3]);
            if (type1 == null) {
                AllMusic.side.sendMessage(sender, AllMusic.getMessage().command.error);
                return;
            }
            AllMusic.side.sendMessage(sender, AllMusic.getMessage().hud.set1.replace(ARG.hud, AllMusic.getMessage().hudList.getHud(this.type)).replace(ARG.dir, AllMusic.getMessage().hudList.getDir(type1)));
        }

        @Override
        public List<String> tab(Object player, String name, String[] args2, int index) {
            if (args2.length == index + 1) {
                return dir;
            }
            return Collections.emptyList();
        }
    }

    private static class HudPos
    extends AHudCommand {
        public HudPos(HudType type) {
            super(type);
        }

        @Override
        public void execute(Object sender, String name, String[] args2) {
            try {
                if (args2.length != 5) {
                    AllMusic.side.sendMessage(sender, AllMusic.getMessage().command.error);
                    return;
                }
                PosObj obj2 = HudUtils.setHudPos(name, this.type, args2[3], args2[4]);
                if (obj2 == null) {
                    AllMusic.side.sendMessageTask(sender, AllMusic.getMessage().command.error);
                    return;
                }
                AllMusic.side.sendMessageTask(sender, AllMusic.getMessage().hud.set.replace(ARG.hud, AllMusic.getMessage().hudList.getHud(this.type)).replace(ARG.x, args2[3]).replace(ARG.y, args2[4]));
            }
            catch (Exception e) {
                AllMusic.side.sendMessage(sender, AllMusic.getMessage().command.error);
            }
        }
    }

    private static class HudReset
    extends AHudCommand {
        public HudReset(HudType type) {
            super(type);
        }

        @Override
        public void execute(Object sender, String name, String[] args2) {
            HudUtils.reset(name, this.type);
            AllMusic.side.sendMessage(sender, AllMusic.getMessage().hud.reset.replace(ARG.hud, AllMusic.getMessage().hudList.getHud(this.type)));
        }
    }

    private static class HudEnable
    extends AHudCommand {
        public HudEnable(HudType type) {
            super(type);
        }

        @Override
        public void execute(Object sender, String name, String[] args2) {
            if (args2.length == 3 || args2.length == 4) {
                boolean temp = HudUtils.setHudEnable(name, this.type, args2.length == 4 ? args2[3] : null);
                AllMusic.side.sendMessageTask(sender, AllMusic.getMessage().hud.state.replace(ARG.state, temp ? AllMusic.getMessage().hudList.enable : AllMusic.getMessage().hudList.disable).replace(ARG.hud, AllMusic.getMessage().hudList.getHud(this.type)));
                return;
            }
            AllMusic.side.sendMessage(sender, AllMusic.getMessage().command.error);
        }

        @Override
        public List<String> tab(Object player, String name, String[] args2, int index) {
            if (args2.length == index + 1) {
                return tf;
            }
            return Collections.emptyList();
        }
    }
}

