/*
 * Decompiled with CFR 0.152.
 */
package com.coloryr.allmusic.server.core.command.sub;

import com.coloryr.allmusic.server.core.AllMusic;
import com.coloryr.allmusic.server.core.command.ACommand;
import com.coloryr.allmusic.server.core.command.ICommand;
import com.coloryr.allmusic.server.core.command.sub.CommandHudSet;
import com.coloryr.allmusic.server.core.objs.enums.HudType;
import com.coloryr.allmusic.server.core.objs.message.ARG;
import com.coloryr.allmusic.server.core.utils.HudUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CommandHud
extends ACommand {
    private static final List<String> hudlist = new ArrayList<String>(){
        {
            this.add("enable");
            this.add("reset");
            this.add("info");
            this.add("list");
            this.add("lyric");
            this.add("pic");
        }
    };
    private final Map<String, ICommand> commandList = new HashMap<String, ICommand>();

    public CommandHud() {
        this.commandList.put("enable", new HudEnable());
        this.commandList.put("reset", new HudReset());
        this.commandList.put("info", new CommandHudSet(HudType.INFO));
        this.commandList.put("list", new CommandHudSet(HudType.LIST));
        this.commandList.put("lyric", new CommandHudSet(HudType.LYRIC));
        this.commandList.put("pic", new CommandHudSet(HudType.PIC));
    }

    @Override
    public void execute(Object sender, String name, String[] args2) {
        if (args2.length == 1) {
            AllMusic.side.sendMessage(sender, AllMusic.getMessage().command.error);
        } else {
            ICommand command = this.commandList.get(args2[1]);
            if (command != null) {
                command.execute(sender, name, args2);
            } else {
                AllMusic.side.sendMessage(sender, AllMusic.getMessage().command.error);
            }
        }
    }

    @Override
    public List<String> tab(Object player, String name, String[] args2, int index) {
        if (args2.length == index + 1) {
            return hudlist;
        }
        ICommand command = this.commandList.get(args2[index]);
        if (command != null) {
            return command.tab(player, name, args2, index + 1);
        }
        return Collections.emptyList();
    }

    private static class HudReset
    extends ACommand {
        private HudReset() {
        }

        @Override
        public void execute(Object sender, String name, String[] args2) {
            HudUtils.reset(name);
            AllMusic.side.sendMessage(sender, AllMusic.getMessage().hud.reset.replace(ARG.hud, AllMusic.getMessage().hudList.getHud(null)));
        }
    }

    private static class HudEnable
    extends ACommand {
        private static final List<String> tf = new ArrayList<String>(){
            {
                this.add("true");
                this.add("false");
            }
        };

        private HudEnable() {
        }

        @Override
        public void execute(Object sender, String name, String[] args2) {
            if (args2.length == 2 || args2.length == 3) {
                boolean temp = HudUtils.setHudEnable(name, null, args2.length == 3 ? args2[2] : null);
                AllMusic.side.sendMessageTask(sender, AllMusic.getMessage().hud.state.replace(ARG.state, temp ? "\u542f\u7528" : "\u5173\u95ed").replace(ARG.hud, AllMusic.getMessage().hudList.getHud(null)));
                return;
            }
            AllMusic.side.sendMessage(sender, AllMusic.getMessage().command.error);
        }

        @Override
        public List<String> tab(Object player, String name, String[] args2, int index) {
            if (args2.length == index + 1) {
                return tf;
            }
            return Collections.emptyList();
        }
    }
}

