/*
 * Decompiled with CFR 0.152.
 */
package com.coloryr.allmusic.server.core.command;

import com.coloryr.allmusic.server.core.AllMusic;
import com.coloryr.allmusic.server.core.command.ICommand;
import com.coloryr.allmusic.server.core.command.sub.CommandAddList;
import com.coloryr.allmusic.server.core.command.sub.CommandBan;
import com.coloryr.allmusic.server.core.command.sub.CommandBanPlayer;
import com.coloryr.allmusic.server.core.command.sub.CommandCancel;
import com.coloryr.allmusic.server.core.command.sub.CommandClearBanList;
import com.coloryr.allmusic.server.core.command.sub.CommandClearBanPlayerList;
import com.coloryr.allmusic.server.core.command.sub.CommandClearList;
import com.coloryr.allmusic.server.core.command.sub.CommandCookie;
import com.coloryr.allmusic.server.core.command.sub.CommandDelete;
import com.coloryr.allmusic.server.core.command.sub.CommandHelp;
import com.coloryr.allmusic.server.core.command.sub.CommandHud;
import com.coloryr.allmusic.server.core.command.sub.CommandLastPage;
import com.coloryr.allmusic.server.core.command.sub.CommandList;
import com.coloryr.allmusic.server.core.command.sub.CommandMute;
import com.coloryr.allmusic.server.core.command.sub.CommandNext;
import com.coloryr.allmusic.server.core.command.sub.CommandNextPage;
import com.coloryr.allmusic.server.core.command.sub.CommandPush;
import com.coloryr.allmusic.server.core.command.sub.CommandReload;
import com.coloryr.allmusic.server.core.command.sub.CommandSearch;
import com.coloryr.allmusic.server.core.command.sub.CommandSelect;
import com.coloryr.allmusic.server.core.command.sub.CommandStop;
import com.coloryr.allmusic.server.core.command.sub.CommandTest;
import com.coloryr.allmusic.server.core.command.sub.CommandUnban;
import com.coloryr.allmusic.server.core.command.sub.CommandUnbanPlayer;
import com.coloryr.allmusic.server.core.command.sub.CommandUrl;
import com.coloryr.allmusic.server.core.command.sub.CommandVote;
import com.coloryr.allmusic.server.core.music.play.MusicSearch;
import com.coloryr.allmusic.server.core.music.play.PlayMusic;
import com.coloryr.allmusic.server.core.objs.message.ARG;
import com.coloryr.allmusic.server.core.objs.music.MusicObj;
import com.coloryr.allmusic.server.core.sql.DataSql;
import com.coloryr.allmusic.server.core.utils.Function;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CommandEX {
    public static final Map<String, ICommand> commandList = new HashMap<String, ICommand>();
    public static final Map<String, ICommand> commandAdminList = new HashMap<String, ICommand>();
    private static final List<String> normal;
    private static final List<String> admin;
    private static final List<String> search;

    public static void searchMusic(Object sender, String name, String[] args2, boolean isDefault) {
        MusicObj obj2 = new MusicObj();
        obj2.sender = sender;
        obj2.name = name;
        obj2.args = args2;
        obj2.isDefault = isDefault;
        if (AllMusic.side.onMusicAdd(sender, obj2)) {
            AllMusic.side.sendMessage(sender, AllMusic.getMessage().addMusic.cancel);
            return;
        }
        MusicSearch.addSearch(obj2);
    }

    public static boolean checkMoney(Object sender, String name, int cost) {
        if (!AllMusic.getConfig().cost.useCost || AllMusic.economy == null) {
            return false;
        }
        if (!AllMusic.economy.check(name, cost)) {
            AllMusic.side.sendMessage(sender, AllMusic.getMessage().cost.noMoney);
            return true;
        }
        return false;
    }

    public static boolean cost(Object sender, String name, int cost, String message) {
        if (!AllMusic.getConfig().cost.useCost || AllMusic.economy == null) {
            return false;
        }
        if (AllMusic.economy.cost(name, cost)) {
            AllMusic.side.sendMessage(sender, message.replace(ARG.cost, String.valueOf(cost)));
            return false;
        }
        AllMusic.side.sendMessage(sender, AllMusic.getMessage().cost.costFail);
        return true;
    }

    public static void addMusic(Object sender, String name, String[] args2) {
        String musicID = args2[0].contains("id=") && !args2[0].contains("/?userid") ? (args2[0].contains("&uct2") ? Function.getString(args2[0], "id=", "&uct2") : (args2[0].contains("&user") ? Function.getString(args2[0], "id=", "&user") : Function.getString(args2[0], "id=", null))) : (args2[0].contains("song/") ? (args2[0].contains("/?userid") ? Function.getString(args2[0], "song/", "/?userid") : Function.getString(args2[0], "song/", null)) : args2[0]);
        if (Function.isInteger(musicID)) {
            if (PlayMusic.getListSize() >= AllMusic.getConfig().maxPlayList) {
                AllMusic.side.sendMessageTask(sender, AllMusic.getMessage().addMusic.listFull);
            } else if (DataSql.checkBanMusic(musicID)) {
                AllMusic.side.sendMessageTask(sender, AllMusic.getMessage().addMusic.banMusic);
            } else if (PlayMusic.haveMusic(musicID)) {
                AllMusic.side.sendMessageTask(sender, AllMusic.getMessage().addMusic.existMusic);
            } else if (PlayMusic.isPlayerMax(name)) {
                AllMusic.side.sendMessageTask(sender, AllMusic.getMessage().addMusic.playerToMany);
            } else if (DataSql.checkBanPlayer(name)) {
                AllMusic.side.sendMessageTask(sender, AllMusic.getMessage().addMusic.playerBan);
            } else {
                if (CommandEX.checkMoney(sender, name, AllMusic.getConfig().cost.addMusicCost)) {
                    return;
                }
                if (CommandEX.cost(sender, name, AllMusic.getConfig().cost.addMusicCost, AllMusic.getMessage().cost.addMusic)) {
                    return;
                }
                DataSql.removeMutePlayer(name);
                if (AllMusic.side.needPlay(false)) {
                    MusicObj obj2 = new MusicObj();
                    obj2.sender = sender;
                    obj2.id = musicID;
                    obj2.name = name;
                    obj2.isDefault = false;
                    if (AllMusic.side.onMusicAdd(sender, obj2)) {
                        AllMusic.side.sendMessageTask(sender, AllMusic.getMessage().addMusic.cancel);
                        return;
                    }
                    PlayMusic.addTask(obj2);
                    AllMusic.side.sendMessageTask(sender, AllMusic.getMessage().addMusic.success);
                } else {
                    AllMusic.side.sendMessageTask(sender, AllMusic.getMessage().addMusic.noPlayer);
                }
            }
        } else {
            AllMusic.side.sendMessageTask(sender, AllMusic.getMessage().addMusic.noID);
        }
    }

    private static boolean isAdmin(String name) {
        for (String item : AllMusic.getConfig().adminList) {
            if (!item.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public static void execute(Object sender, String name, String[] args2) {
        try {
            if (args2.length == 0) {
                AllMusic.side.sendMessage(sender, AllMusic.getMessage().command.error);
                return;
            }
            ICommand command = commandList.get(args2[0]);
            if (command != null) {
                command.execute(sender, name, args2);
                return;
            }
            if (CommandEX.checkAdmin(sender, name) && (command = commandAdminList.get(args2[0])) != null) {
                command.execute(sender, name, args2);
                return;
            }
            if (AllMusic.getConfig().needPermission && !AllMusic.side.checkPermission(sender, "allmusic.addmusic")) {
                AllMusic.side.sendMessage(sender, AllMusic.getMessage().command.noPer);
            } else {
                switch (AllMusic.getConfig().defaultAddMusic) {
                    case 1: {
                        CommandEX.searchMusic(sender, name, args2, true);
                        break;
                    }
                    default: {
                        DataSql.task(() -> CommandEX.addMusic(sender, name, args2));
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static List<String> getTabList(Object sender, String name, String[] arg) {
        ArrayList<String> arguments = new ArrayList<String>();
        if (arg.length == 0) {
            arguments.addAll(normal);
            if (CommandEX.checkAdmin(sender, name)) {
                arguments.addAll(admin);
            }
            if (AllMusic.getSearch(name) != null) {
                return search;
            }
        } else if (arg[0] == null || arg[0].isEmpty() || arg.length == 1) {
            arguments.addAll(normal);
            if (CommandEX.checkAdmin(sender, name)) {
                arguments.addAll(admin);
            }
            if ((arg[0] == null || arg[0].isEmpty()) && AllMusic.getSearch(name) != null) {
                return search;
            }
        } else {
            ICommand command = commandList.get(arg[0]);
            if (command != null) {
                arguments.addAll(command.tab(sender, name, arg, 1));
            }
            if (CommandEX.checkAdmin(sender, name) && (command = commandAdminList.get(arg[0])) != null) {
                arguments.addAll(command.tab(sender, name, arg, 1));
            }
        }
        return arguments;
    }

    public static boolean checkAdmin(Object sender, String name) {
        return CommandEX.isAdmin(name) || AllMusic.side.checkPermission(sender);
    }

    static {
        commandList.put("stop", new CommandStop());
        commandList.put("help", new CommandHelp());
        commandList.put("list", new CommandList());
        commandList.put("vote", new CommandVote());
        commandList.put("mute", new CommandMute());
        commandList.put("search", new CommandSearch());
        commandList.put("select", new CommandSelect());
        commandList.put("nextpage", new CommandNextPage());
        commandList.put("lastpage", new CommandLastPage());
        commandList.put("hud", new CommandHud());
        commandList.put("reload", new CommandReload());
        commandList.put("push", new CommandPush());
        commandList.put("cancel", new CommandCancel());
        commandAdminList.put("next", new CommandNext());
        commandAdminList.put("ban", new CommandBan());
        commandAdminList.put("unban", new CommandUnban());
        commandAdminList.put("banplayer", new CommandBanPlayer());
        commandAdminList.put("unbanplayer", new CommandUnbanPlayer());
        commandAdminList.put("url", new CommandUrl());
        commandAdminList.put("delete", new CommandDelete());
        commandAdminList.put("addlist", new CommandAddList());
        commandAdminList.put("clearlist", new CommandClearList());
        commandAdminList.put("clearban", new CommandClearBanList());
        commandAdminList.put("clearbanplayer", new CommandClearBanPlayerList());
        commandAdminList.put("cookie", new CommandCookie());
        commandAdminList.put("test", new CommandTest());
        normal = new ArrayList<String>(){
            {
                this.addAll(commandList.keySet());
            }
        };
        admin = new ArrayList<String>(){
            {
                this.addAll(commandAdminList.keySet());
            }
        };
        search = new ArrayList<String>(){
            {
                this.add("select");
                this.add("nextpage");
                this.add("lastpage");
            }
        };
    }
}

