/*
 * Decompiled with CFR 0.152.
 */
package com.coloryr.allmusic.server.core;

import com.coloryr.allmusic.server.core.music.api.APIMain;
import com.coloryr.allmusic.server.core.music.play.MusicSearch;
import com.coloryr.allmusic.server.core.music.play.PlayMusic;
import com.coloryr.allmusic.server.core.music.play.PlayRuntime;
import com.coloryr.allmusic.server.core.objs.CookieObj;
import com.coloryr.allmusic.server.core.objs.config.ConfigObj;
import com.coloryr.allmusic.server.core.objs.message.MessageObj;
import com.coloryr.allmusic.server.core.objs.music.SearchPageObj;
import com.coloryr.allmusic.server.core.objs.music.SongInfoObj;
import com.coloryr.allmusic.server.core.side.BaseSide;
import com.coloryr.allmusic.server.core.side.IMyLogger;
import com.coloryr.allmusic.server.core.sql.DataSql;
import com.coloryr.allmusic.server.core.sql.IEconomy;
import com.coloryr.allmusic.server.lib.com.google.gson.Gson;
import com.coloryr.allmusic.server.lib.com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;

public class AllMusic {
    public static final Gson gson = new Gson();
    public static final Random random = new Random();
    public static final String channel = "allmusic:channel";
    public static final String channelBC = "allmusic:channelbc";
    public static final String version = "3.5.0";
    public static final String configVersion = "204";
    public static final String messageVersion = "208";
    private static final Map<String, SearchPageObj> searchSave = new HashMap<String, SearchPageObj>();
    private static final Set<String> nowPlayPlayer = new HashSet<String>();
    public static IMyLogger log;
    public static BaseSide side;
    public static boolean isRun;
    public static CookieObj cookie;
    public static IEconomy economy;
    private static APIMain apiMusic;
    private static ConfigObj config;
    private static MessageObj message;
    private static File configFile;
    private static File cookieFile;
    private static File messageFile;

    public static void configCheck() {
        if (config == null || config.check()) {
            config = ConfigObj.make();
            log.warning("\u00a7d[AllMusic3]\u00a7c\u914d\u7f6e\u6587\u4ef6config.json\u9519\u8bef\uff0c\u5df2\u8986\u76d6");
            AllMusic.saveConfig();
        }
    }

    private static void messageCheck() {
        if (message == null || message.check()) {
            message = MessageObj.make();
            log.warning("\u00a7d[AllMusic3]\u00a7c\u914d\u7f6e\u6587\u4ef6message.json\u9519\u8bef\uff0c\u5df2\u8986\u76d6");
            AllMusic.saveMessage();
        }
    }

    public static Set<String> getNowPlayPlayer() {
        return nowPlayPlayer;
    }

    public static boolean isSkip(String name, String server, boolean checkPlay) {
        try {
            name = name.toLowerCase();
            if (server != null && AllMusic.getConfig().muteServer.contains(server)) {
                return true;
            }
            if (DataSql.checkMutePlayer(name)) {
                return true;
            }
            if (PlayMusic.nowPlayMusic != null && PlayMusic.nowPlayMusic.isList() && DataSql.checkMuteListPlayer(name)) {
                return true;
            }
            if (!checkPlay) {
                return false;
            }
            return AllMusic.containNowPlay(name);
        }
        catch (NoSuchElementException e) {
            return true;
        }
    }

    public static boolean isSkip(String name, String server, boolean checkPlay, boolean islist) {
        try {
            name = name.toLowerCase();
            if (server != null && AllMusic.getConfig().muteServer.contains(server)) {
                return true;
            }
            if (DataSql.checkMutePlayer(name)) {
                return true;
            }
            if (islist && DataSql.checkMuteListPlayer(name)) {
                return true;
            }
            if (!checkPlay) {
                return false;
            }
            return AllMusic.containNowPlay(name);
        }
        catch (NoSuchElementException e) {
            return true;
        }
    }

    public static boolean containNowPlay(String player) {
        return !nowPlayPlayer.contains(player = player.toLowerCase());
    }

    public static ConfigObj getConfig() {
        if (config == null) {
            log.warning("\u00a7d[AllMusic3]\u00a7c\u914d\u7f6e\u6587\u4ef6config.json\u9519\u8bef\uff0c\u5df2\u4f7f\u7528\u9ed8\u8ba4\u914d\u7f6e\u6587\u4ef6");
            config = ConfigObj.make();
        }
        return config;
    }

    public static MessageObj getMessage() {
        if (message == null) {
            log.warning("\u00a7d[AllMusic3]\u00a7c\u914d\u7f6e\u6587\u4ef6message.json\u9519\u8bef\uff0c\u5df2\u4f7f\u7528\u9ed8\u8ba4\u914d\u7f6e\u6587\u4ef6");
            message = MessageObj.make();
        }
        return message;
    }

    public static void addSearch(String player, SearchPageObj page) {
        player = player.toLowerCase();
        searchSave.put(player, page);
    }

    public static SearchPageObj getSearch(String player) {
        player = player.toLowerCase();
        return searchSave.get(player);
    }

    public static void removeSearch(String player) {
        player = player.toLowerCase();
        searchSave.remove(player);
    }

    public static void addNowPlayPlayer(String player) {
        player = player.toLowerCase();
        nowPlayPlayer.add(player);
    }

    public static void removeNowPlayPlayer(String player) {
        player = player.toLowerCase();
        nowPlayPlayer.remove(player);
    }

    public static void clearNowPlayer() {
        nowPlayPlayer.clear();
    }

    public static void saveConfig() {
        try {
            String data = new GsonBuilder().setPrettyPrinting().create().toJson(config);
            FileOutputStream out = new FileOutputStream(configFile);
            OutputStreamWriter write = new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8);
            write.write(data);
            write.close();
            out.close();
        }
        catch (Exception e) {
            log.warning("\u00a7d[AllMusic3]\u00a7c\u914d\u7f6e\u6587\u4ef6\u4fdd\u5b58\u9519\u8bef");
            e.printStackTrace();
        }
    }

    public static void saveMessage() {
        try {
            String data = new GsonBuilder().setPrettyPrinting().create().toJson(message);
            FileOutputStream out = new FileOutputStream(messageFile);
            OutputStreamWriter write = new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8);
            write.write(data);
            write.close();
            out.close();
        }
        catch (Exception e) {
            log.warning("\u00a7d[AllMusic3]\u00a7c\u914d\u7f6e\u6587\u4ef6\u4fdd\u5b58\u9519\u8bef");
            e.printStackTrace();
        }
    }

    public static void saveCookie() {
        try {
            String data = new GsonBuilder().setPrettyPrinting().create().toJson(cookie);
            FileOutputStream out = new FileOutputStream(cookieFile);
            OutputStreamWriter write = new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8);
            write.write(data);
            write.close();
        }
        catch (Exception e) {
            log.warning("\u00a7d[AllMusic3]\u00a7c\u914d\u7f6e\u6587\u4ef6\u4fdd\u5b58\u9519\u8bef");
            e.printStackTrace();
        }
    }

    public static void start() {
        apiMusic = new APIMain();
        PlayMusic.start();
        PlayRuntime.start();
        MusicSearch.start();
        DataSql.start();
        log.info("\u00a7d[AllMusic3]\u00a7e\u5df2\u542f\u52a8-3.5.0");
    }

    public static void stop() {
        PlayMusic.clearVote();
        PlayMusic.clearPush();
        side.sendStop();
        MusicSearch.stop();
        PlayMusic.stop();
        PlayRuntime.stop();
        DataSql.stop();
        log.info("\u00a7d[AllMusic3]\u00a72\u00a7e\u5df2\u505c\u6b62\uff0c\u611f\u8c22\u4f7f\u7528");
    }

    public static APIMain getMusicApi() {
        return apiMusic;
    }

    private static void loadConfig() {
        try {
            InputStreamReader reader = new InputStreamReader(Files.newInputStream(configFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);
            BufferedReader bf = new BufferedReader(reader);
            config = new Gson().fromJson((Reader)bf, ConfigObj.class);
            bf.close();
            reader.close();
            AllMusic.configCheck();
            reader = new InputStreamReader(Files.newInputStream(messageFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);
            bf = new BufferedReader(reader);
            message = new Gson().fromJson((Reader)bf, MessageObj.class);
            bf.close();
            reader.close();
            AllMusic.messageCheck();
            log.info("\u00a7d[AllMusic3]\u00a7e\u5f53\u524d\u8bed\u8a00\u914d\u7f6e\u6587\u4ef6\u7248\u672c\u4e3a\uff1a208\uff0c\u4f60\u7684\u8bed\u8a00\u6587\u4ef6\u7248\u672c\u4e3a\uff1a" + AllMusic.message.version);
            if (!AllMusic.message.version.equalsIgnoreCase(messageVersion)) {
                log.warning("\u00a7d[AllMusic3]\u00a7c\u8bed\u8a00\u6587\u4ef6\u7248\u672c\u53f7\u9519\u8bef\uff0c\u8fd0\u884c\u53ef\u80fd\u4f1a\u53d1\u751f\u95ee\u9898\uff0c\u8bf7\u5220\u9664\u540e\u91cd\u8f7d");
            }
            reader = new InputStreamReader(Files.newInputStream(cookieFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);
            bf = new BufferedReader(reader);
            cookie = new Gson().fromJson((Reader)bf, CookieObj.class);
            bf.close();
            reader.close();
            if (cookie == null || AllMusic.cookie.cookieStore == null) {
                cookie = new CookieObj();
                AllMusic.saveCookie();
            }
            log.info("\u00a7d[AllMusic3]\u00a7e\u5f53\u524d\u63d2\u4ef6\u914d\u7f6e\u6587\u4ef6\u7248\u672c\u4e3a\uff1a204\uff0c\u4f60\u7684\u914d\u7f6e\u6587\u4ef6\u7248\u672c\u4e3a\uff1a" + AllMusic.config.version);
            if (!configVersion.equalsIgnoreCase(AllMusic.config.version)) {
                log.warning("\u00a7d[AllMusic3]\u00a7c\u8bf7\u53ca\u65f6\u66f4\u65b0\u914d\u7f6e\u6587\u4ef6");
            }
        }
        catch (Exception e) {
            log.warning("\u00a7d[AllMusic3]\u00a7c\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6\u9519\u8bef");
            e.printStackTrace();
        }
    }

    public static void joinPlay(String player) {
        DataSql.task(() -> {
            String player1 = player.toLowerCase();
            if (DataSql.checkMutePlayer(player1) || nowPlayPlayer.contains(player1)) {
                return;
            }
            if (DataSql.checkMuteListPlayer(player1) && PlayMusic.nowPlayMusic != null && PlayMusic.nowPlayMusic.isList()) {
                return;
            }
            side.runTask(() -> {
                SongInfoObj music = PlayMusic.nowPlayMusic;
                if (music != null && PlayMusic.url != null) {
                    side.sendHudPos(player1);
                    side.sendMusic(player1, PlayMusic.url);
                    if (!music.isUrl()) {
                        side.sendPic(player1, music.getPicUrl());
                    }
                    side.sendPos(player1, (int)PlayMusic.musicNowTime);
                }
            }, 20);
        });
    }

    public void init(File file) {
        log.info("\u00a7d[AllMusic3]\u00a72\u00a7e\u6b63\u5728\u542f\u52a8\uff0c\u611f\u8c22\u4f7f\u7528\uff0c\u672c\u63d2\u4ef6\u4ea4\u6d41\u7fa4\uff1a571239090");
        try {
            if (!file.exists()) {
                file.mkdir();
            }
            if (configFile == null) {
                configFile = new File(file, "config.json");
            }
            if (messageFile == null) {
                messageFile = new File(file, "message.json");
            }
            if (cookieFile == null) {
                cookieFile = new File(file, "cookie.json");
            }
            if (DataSql.sqlFile == null) {
                DataSql.sqlFile = new File(file, "data.db");
            }
            if (!configFile.exists()) {
                configFile.createNewFile();
            }
            if (!messageFile.exists()) {
                messageFile.createNewFile();
            }
            if (!cookieFile.exists()) {
                cookieFile.createNewFile();
            }
            AllMusic.loadConfig();
            isRun = true;
        }
        catch (IOException e) {
            isRun = false;
            log.warning("\u00a7d[AllMusic3]\u00a7c\u542f\u52a8\u5931\u8d25");
            e.printStackTrace();
        }
    }
}

