/*
 * Decompiled with CFR 0.152.
 */
package com.coloryr.allmusic.client.core.player.decoder.mp3;

import com.coloryr.allmusic.client.core.player.AllMusicPlayer;
import com.coloryr.allmusic.client.core.player.decoder.BuffPack;
import com.coloryr.allmusic.client.core.player.decoder.IDecoder;
import com.coloryr.allmusic.client.core.player.decoder.mp3.Bitstream;
import com.coloryr.allmusic.client.core.player.decoder.mp3.DecoderErrors;
import com.coloryr.allmusic.client.core.player.decoder.mp3.DecoderException;
import com.coloryr.allmusic.client.core.player.decoder.mp3.Equalizer;
import com.coloryr.allmusic.client.core.player.decoder.mp3.FrameDecoder;
import com.coloryr.allmusic.client.core.player.decoder.mp3.Header;
import com.coloryr.allmusic.client.core.player.decoder.mp3.LayerIDecoder;
import com.coloryr.allmusic.client.core.player.decoder.mp3.LayerIIDecoder;
import com.coloryr.allmusic.client.core.player.decoder.mp3.LayerIIIDecoder;
import com.coloryr.allmusic.client.core.player.decoder.mp3.SampleBuffer;
import com.coloryr.allmusic.client.core.player.decoder.mp3.SynthesisFilter;

public class Mp3Decoder
implements DecoderErrors,
IDecoder {
    private static final Params DEFAULT_PARAMS = new Params();
    private final AllMusicPlayer player;
    private final BuffPack pack = new BuffPack();
    private SampleBuffer output;
    private SynthesisFilter filter1;
    private SynthesisFilter filter2;
    private LayerIIIDecoder l3decoder;
    private LayerIIDecoder l2decoder;
    private LayerIDecoder l1decoder;
    private int outputFrequency;
    private int outputChannels;
    private boolean initialized;
    private Bitstream bitstream;
    private byte[] byteBuf = new byte[4096];

    public Mp3Decoder(AllMusicPlayer player) {
        this.player = player;
        Equalizer eq = DEFAULT_PARAMS.getInitialEqualizerSettings();
        if (eq != null) {
            Equalizer equalizer = new Equalizer();
            equalizer.setFrom(eq);
        }
    }

    protected byte[] getByteArray(int length) {
        if (this.byteBuf.length < length) {
            this.byteBuf = new byte[length + 1024];
        }
        return this.byteBuf;
    }

    protected byte[] toByteArray(short[] samples, int offs, int len) {
        byte[] b = this.getByteArray(len * 2);
        int idx = 0;
        while (len-- > 0) {
            short s = samples[offs++];
            b[idx++] = (byte)s;
            b[idx++] = (byte)(s >>> 8);
        }
        return b;
    }

    @Override
    public BuffPack decodeFrame() throws Exception {
        Header header = this.bitstream.readFrame();
        if (header == null) {
            return null;
        }
        int layer = header.layer();
        this.output.clear_buffer();
        FrameDecoder decoder = this.retrieveDecoder(header, this.bitstream, layer);
        decoder.decodeFrame();
        this.bitstream.closeFrame();
        this.pack.buff = this.toByteArray(this.output.getBuffer(), 0, this.output.getBufferLength());
        this.pack.len = this.output.getBufferLength() * 2;
        return this.pack;
    }

    @Override
    public void close() throws Exception {
        this.bitstream.close();
    }

    @Override
    public boolean set() throws Exception {
        this.bitstream = new Bitstream(this.player);
        Header header = this.bitstream.readFrame();
        if (header == null) {
            return false;
        }
        if (!this.initialized) {
            this.initialize(header);
        }
        return true;
    }

    @Override
    public int getOutputFrequency() {
        return this.outputFrequency;
    }

    @Override
    public int getOutputChannels() {
        return this.outputChannels;
    }

    @Override
    public void set(int time) {
        try {
            long data = (long)(time / 26) * (long)this.bitstream.getframesize() + this.bitstream.local;
            this.player.setLocal(data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected DecoderException newDecoderException() {
        return new DecoderException(513, null);
    }

    protected FrameDecoder retrieveDecoder(Header header, Bitstream stream, int layer) throws DecoderException {
        FrameDecoder decoder = null;
        switch (layer) {
            case 3: {
                if (this.l3decoder == null) {
                    this.l3decoder = new LayerIIIDecoder(stream, header, this.filter1, this.filter2, this.output, 0);
                }
                decoder = this.l3decoder;
                break;
            }
            case 2: {
                if (this.l2decoder == null) {
                    this.l2decoder = new LayerIIDecoder();
                    this.l2decoder.create(stream, header, this.filter1, this.filter2, this.output, 0);
                }
                decoder = this.l2decoder;
                break;
            }
            case 1: {
                if (this.l1decoder == null) {
                    this.l1decoder = new LayerIDecoder();
                    this.l1decoder.create(stream, header, this.filter1, this.filter2, this.output, 0);
                }
                decoder = this.l1decoder;
            }
        }
        if (decoder == null) {
            throw this.newDecoderException();
        }
        return decoder;
    }

    private void initialize(Header header) {
        int channels;
        float scalefactor = 32700.0f;
        int mode = header.mode();
        int n = channels = mode == 3 ? 1 : 2;
        if (this.output == null) {
            this.output = new SampleBuffer(channels);
        }
        this.filter1 = new SynthesisFilter(0, scalefactor);
        if (channels == 2) {
            this.filter2 = new SynthesisFilter(1, scalefactor);
        }
        this.outputChannels = channels;
        this.outputFrequency = header.frequency();
        this.initialized = true;
    }

    public static class Params
    implements Cloneable {
        private final Equalizer equalizer = new Equalizer();

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new InternalError(String.valueOf(this) + ": " + String.valueOf(ex));
            }
        }

        public Equalizer getInitialEqualizerSettings() {
            return this.equalizer;
        }
    }
}

